/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.formatting;

import com.exlibris.core.sdk.strings.StringUtils;
import com.exlibris.digitool.repository.api.xmlbeans.Md;
import gov.loc.marc21.slim.CollectionDocument;
import gov.loc.marc21.slim.ControlFieldType;
import gov.loc.marc21.slim.DataFieldType;
import gov.loc.marc21.slim.InsFieldType;
import gov.loc.marc21.slim.LeaderFieldType;
import gov.loc.marc21.slim.RecordDocument;
import gov.loc.marc21.slim.RecordType;
import gov.loc.marc21.slim.SubfieldatafieldType;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlString;

public class MarcHandler {
    CollectionDocument collectionDocument;
    private static final int MAX_CONTROL_FIELD = 8;
    private static final String CONTROL_FIELD = "controlfield";
    private static final int NOT_FOUND = -1;
    private static final String ignoreInd = "#";

    public MarcHandler() {
        this.collectionDocument = CollectionDocument.Factory.newInstance();
        this.collectionDocument.addNewCollection().addNewRecord();
    }

    private void init(RecordType record) throws XmlException {
        this.collectionDocument = CollectionDocument.Factory.newInstance();
        this.collectionDocument.addNewCollection().addNewRecord();
        this.collectionDocument.getCollection().setRecordArray(0, record);
    }

    public void setRecordType(RecordType rec) throws XmlException {
        this.init(rec);
    }

    public MarcHandler(String recordXml) throws XmlException {
        RecordType record = RecordType.Factory.parse(recordXml);
        this.init(record);
    }

    public MarcHandler(RecordType record) throws XmlException {
        this.init(record);
    }

    public String getCollectionDocument() {
        return this.collectionDocument.toString();
    }

    public RecordType getRecord() {
        RecordType[] records = this.collectionDocument.getCollection().getRecordArray();
        if (records.length > 0) {
            return records[0];
        }
        return this.collectionDocument.getCollection().addNewRecord();
    }

    public void addGeneralElement(String tag, String value) throws Exception {
        if (Integer.parseInt(tag.substring(0, 3)) <= 8) {
            this.addControlField(tag, value);
        } else {
            this.addElement(tag, value);
        }
    }

    public void addGeneralElementByXPath(String path, String value) throws Exception {
        if (path != null && path.startsWith(CONTROL_FIELD)) {
            String tag = null;
            StringTokenizer st = new StringTokenizer(path, "/");
            if (st.hasMoreElements()) {
                st.nextElement();
            }
            if (st.hasMoreElements()) {
                tag = (String)st.nextElement();
            }
            this.addControlField(tag, value);
        } else if (path != null && path.indexOf("/") > 0 && StringUtils.isDigitsString(path.substring(0, path.indexOf("/")))) {
            this.addElement(path, value);
        } else {
            this.addFixElement(path, value);
        }
    }

    public ControlFieldType addControlField(String tag, String value) {
        ControlFieldType cft = this.getRecord().addNewControlfield();
        cft.setTag(tag);
        cft.setStringValue(value);
        return cft;
    }

    public String getControlFieldValue(String tag) {
        ControlFieldType cft = this.getControlField(tag);
        if (cft != null) {
            return cft.getStringValue();
        }
        return null;
    }

    private ControlFieldType getControlField(String tag) {
        ControlFieldType[] cflds = this.getRecord().getControlfieldArray();
        if (cflds == null) {
            return null;
        }
        for (int i = 0; i < cflds.length; ++i) {
            ControlFieldType type = cflds[i];
            if (type.getTag() == null || !type.getTag().equals(tag)) continue;
            return type;
        }
        return null;
    }

    public DataFieldType addElement(String tag, String ind1, String ind2, String code, String value) {
        DataFieldType dft = this.getDataField(tag, ind1, ind2, null);
        return this.addElement(dft, code, value);
    }

    public XmlString addFixElement(String tag, String value) {
        if (tag.equalsIgnoreCase("ins")) {
            InsFieldType ift = this.getRecord().addNewIns();
            ift.setStringValue(value);
            return ift;
        }
        if (tag.equalsIgnoreCase("leader")) {
            LeaderFieldType lft = this.getRecord().addNewLeader();
            lft.setStringValue(value);
            return lft;
        }
        return null;
    }

    public void removeGeneralElement(String tag) {
        if (Integer.parseInt(tag = tag.substring(0, 3).trim()) <= 8) {
            this.removeControlField(tag);
        } else {
            this.removeDataField(tag, "", "");
        }
    }

    public void removeControlField(String tag) {
        int ix = this.getControlFieldIndex(tag);
        if (ix != -1) {
            this.getRecord().removeControlfield(ix);
        }
    }

    public void removeDataField(String tag, String ind1, String ind2) {
        int ix = this.getDataFieldIndex(tag, ind1, ind2);
        if (ix != -1) {
            this.getRecord().removeDatafield(ix);
        }
    }

    private int getDataFieldIndex(String tag, String ind1, String ind2) {
        DataFieldType[] dflds = this.getRecord().getDatafieldArray();
        if (dflds == null) {
            return -1;
        }
        for (int i = 0; i < dflds.length; ++i) {
            DataFieldType type = dflds[i];
            if (type.getTag() == null || !type.getTag().equals(tag) || type.getInd1() != null && !ind1.equals(ignoreInd) && !type.getInd1().trim().equals(ind1.trim()) || type.getInd2() != null && !ind2.equals(ignoreInd) && !type.getInd2().trim().equals(ind2.trim())) continue;
            return i;
        }
        return -1;
    }

    private int getControlFieldIndex(String tag) {
        ControlFieldType[] cflds = this.getRecord().getControlfieldArray();
        if (cflds == null) {
            return -1;
        }
        for (int i = 0; i < cflds.length; ++i) {
            ControlFieldType type = cflds[i];
            if (type.getTag() == null || !type.getTag().equals(tag)) continue;
            return i;
        }
        return -1;
    }

    public DataFieldType addElement(String path, String value) {
        String tag = "";
        String ind1 = "";
        String ind2 = "";
        String code = "";
        StringTokenizer st = new StringTokenizer(path, "/");
        if (st.hasMoreElements()) {
            tag = (String)st.nextElement();
        }
        if (st.hasMoreElements()) {
            ind1 = (String)st.nextElement();
        }
        if (st.hasMoreElements()) {
            ind2 = (String)st.nextElement();
        }
        if (st.hasMoreElements()) {
            code = (String)st.nextElement();
        }
        return this.addElement(tag, ind1, ind2, code, value);
    }

    public String getValue(String path) {
        if (path.startsWith("/controlfield/")) {
            return this.getControlFieldValue(path.substring(14));
        }
        SubfieldatafieldType sf = this.getSubField(path);
        if (sf == null) {
            return null;
        }
        return sf.getStringValue();
    }

    public Vector getValues(String path) {
        if (path.startsWith("/controlfield/")) {
            return this.getControlFields(path.substring(14));
        }
        Vector<String> v = new Vector<String>();
        Vector sfs = this.getSubFields(path);
        for (int i = 0; i < sfs.size(); ++i) {
            v.add((String)sfs.elementAt(i));
        }
        return v;
    }

    public String toXml() {
        String marcXml = null;
        try {
            RecordType rt = this.collectionDocument.getCollection().getRecordArray(0);
            RecordDocument rd = RecordDocument.Factory.parse(rt.newCursor().xmlText());
            XmlOptions options = new XmlOptions();
            options.setSavePrettyPrint();
            marcXml = rd.xmlText(options);
            marcXml = marcXml.replaceFirst(" xmlns:slim=", " xmlns=");
            marcXml = marcXml.replaceAll("<slim:", "<");
            marcXml = marcXml.replaceAll("</slim:", "</");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return marcXml;
    }

    private DataFieldType addElement(DataFieldType dft, String code, String value) {
        SubfieldatafieldType sfdt = dft.addNewSubfield();
        sfdt.setCode(code);
        sfdt.setStringValue(value);
        return dft;
    }

    public Vector getControlFields(String path) {
        Vector<String> v = new Vector<String>();
        ControlFieldType[] cfts = this.collectionDocument.getCollection().getRecordArray(0).getControlfieldArray();
        for (int i = 0; i < cfts.length; ++i) {
            if (!path.equals(cfts[i].getTag())) continue;
            v.add(cfts[i].getStringValue());
        }
        return v;
    }

    private Vector getSubFields(String path) {
        String tag = "";
        String ind1 = "";
        String ind2 = "";
        String code = "";
        String sfDelimiter = " ";
        StringTokenizer st = new StringTokenizer(path, "/");
        if (st.hasMoreElements()) {
            tag = (String)st.nextElement();
        }
        if (st.hasMoreElements()) {
            ind1 = (String)st.nextElement();
        }
        if (st.hasMoreElements()) {
            ind2 = (String)st.nextElement();
        }
        if (st.hasMoreElements()) {
            code = (String)st.nextElement();
            code = StringUtils.remove_blanks(code).trim();
        }
        if (st.hasMoreElements()) {
            sfDelimiter = (String)st.nextElement();
        }
        Vector<String> v = new Vector<String>();
        Vector dfts = this.getDataFields(tag, ind1, ind2);
        for (int j = 0; j < dfts.size(); ++j) {
            SubfieldatafieldType[] sflds = ((DataFieldType)dfts.elementAt(j)).getSubfieldArray();
            if (code.length() > 1) {
                String tmpStr = new String();
                for (int kk = 0; kk < sflds.length; ++kk) {
                    SubfieldatafieldType type = sflds[kk];
                    if (code.indexOf(type.getCode()) <= -1) continue;
                    if (tmpStr.length() > 0) {
                        tmpStr = tmpStr + sfDelimiter;
                    }
                    tmpStr = tmpStr + type.getStringValue();
                }
                if (tmpStr.endsWith(sfDelimiter)) {
                    tmpStr = tmpStr.substring(0, tmpStr.length() - sfDelimiter.length());
                }
                v.add(tmpStr);
                continue;
            }
            for (int i = 0; i < sflds.length; ++i) {
                SubfieldatafieldType type = sflds[i];
                if (!type.getCode().equals(code) && !ignoreInd.equals(code)) continue;
                v.add(type.getStringValue());
            }
        }
        return v;
    }

    private SubfieldatafieldType getSubField(String path) {
        String tag = "";
        String ind1 = "";
        String ind2 = "";
        String code = "";
        String index = "";
        StringTokenizer st = new StringTokenizer(path, "/");
        if (st.hasMoreElements()) {
            tag = (String)st.nextElement();
        }
        if (st.hasMoreElements()) {
            ind1 = (String)st.nextElement();
        }
        if (st.hasMoreElements()) {
            ind2 = (String)st.nextElement();
        }
        if (st.hasMoreElements()) {
            code = (String)st.nextElement();
        }
        if (st.hasMoreElements()) {
            index = (String)st.nextElement();
        }
        DataFieldType dft = this.getDataField(tag, ind1, ind2, index);
        SubfieldatafieldType[] sflds = dft.getSubfieldArray();
        for (int i = 0; i < sflds.length; ++i) {
            SubfieldatafieldType type = sflds[i];
            if (!type.getCode().equals(code) && !ignoreInd.equals(code)) continue;
            return type;
        }
        return null;
    }

    public Vector getDataFields(String tag, String ind1, String ind2) {
        DataFieldType[] dflds = this.getRecord().getDatafieldArray();
        Vector<DataFieldType> v = new Vector<DataFieldType>();
        if (dflds != null) {
            for (int i = 0; i < dflds.length; ++i) {
                DataFieldType type = dflds[i];
                if (type.getTag() == null || !type.getTag().equals(tag) || type.getInd1() != null && !ind1.equals(ignoreInd) && !type.getInd1().equals(ind1) || type.getInd2() != null && !ind2.equals(ignoreInd) && !type.getInd2().equals(ind2)) continue;
                v.add(type);
            }
        }
        return v;
    }

    private DataFieldType getDataField(String tag, String ind1, String ind2, String index) {
        int inx = 0;
        try {
            inx = Integer.valueOf(index);
            if (inx > 0) {
                --inx;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DataFieldType[] dflds = this.getRecord().getDatafieldArray();
        if (dflds != null) {
            int internalIndex = 0;
            for (int i = 0; i < dflds.length; ++i) {
                DataFieldType type = dflds[i];
                if (type.getTag() == null || !type.getTag().equals(tag) || type.getInd1() != null && !ind1.equals(ignoreInd) && !type.getInd1().trim().equals(ind1) || type.getInd2() != null && !ind2.equals(ignoreInd) && !type.getInd2().trim().equals(ind2)) continue;
                if (inx > internalIndex) {
                    ++internalIndex;
                    continue;
                }
                return type;
            }
        }
        DataFieldType dft = this.getRecord().addNewDatafield();
        dft.setTag(tag);
        dft.setInd1(this.setIndicator(ind1));
        dft.setInd2(this.setIndicator(ind2));
        return dft;
    }

    private String setIndicator(String ind) {
        if (ind == null || ind.length() == 0 || ind.equals(ignoreInd)) {
            return " ";
        }
        return ind;
    }

    public static void main(String[] args) throws Exception {
        String marcStr = "<record xmlns=\"http://www.loc.gov/MARC21/slim\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd\"><leader>^^^^^nkm^a22^^^^^^a^4500</leader><controlfield tag=\"FMT\">IM</controlfield><controlfield tag=\"008\">^^^^^^m18711873ctunnn^^^^^^^f000^kneng^d</controlfield><datafield tag=\"100\" ind1=\" \" ind2=\" \"><subfield code=\"a\">dsfgdg</subfield></datafield><datafield tag=\"245\" ind1=\" \" ind2=\" \"><subfield code=\"a\">dasfsd</subfield></datafield></record>";
        String s = "<slim:record xmlns:slim=\"http://www.loc.gov/MARC21/slim\"><slim:record xmlns:slim=\"http://www.loc.gov/MARC21/slim\"><slim:record xmlns:slim=\"http://www.loc.gov/MARC21/slim\"><slim:datafield ind2=\" \" ind1=\" \" tag=\"245\"><slim:subfield code=\"a\">team4.jpg</slim:subfield></slim:datafield></slim:record><slim:datafield ind2=\" \" ind1=\" \" tag=\"524\"><slim:subfield code=\"a\">karting</slim:subfield></slim:datafield></slim:record><slim:datafield ind2=\" \" ind1=\"1\" tag=\"520\"><slim:subfield code=\"b\">Ben</slim:subfield></slim:datafield></slim:record>";
        Md md = Md.Factory.newInstance();
        md.setValue(marcStr);
        RecordDocument marcrecord = RecordDocument.Factory.parse(md.getValue());
        MarcHandler mh = new MarcHandler(marcrecord.getRecord());
        System.out.println(mh.getValues("/controlfield/FMT"));
        System.out.println(mh.toXml());
    }
}

