/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.streams;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.scriptRunner.ExecExternalProcess;
import com.exlibris.digitool.exceptions.ScriptException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class ExternalProcessUtil {
    private static final ExLogger logger = ExLogger.getExLogger(ExternalProcessUtil.class);

    public static String runScript(String script, String paramsPattern, Object[] params) throws ScriptException {
        if (params != null && params.length != 0) {
            Iterator<Object> paramsIter = Arrays.asList(params).iterator();
            int i = 1;
            try {
                while (paramsIter.hasNext()) {
                    paramsPattern = com.exlibris.core.sdk.strings.StringUtils.replaceSubString(paramsPattern, "$" + i++, (String)paramsIter.next());
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                logger.error("Failed to replace sub-string on string: " + paramsPattern, e, new String[0]);
                throw e;
            }
        }
        logger.info("Execute:" + script + " " + paramsPattern);
        ExecExternalProcess proc = new ExecExternalProcess();
        Vector paramsVector = com.exlibris.core.sdk.strings.StringUtils.extractValues(paramsPattern, " ", false);
        LinkedList<String> args = new LinkedList<String>(paramsVector);
        int exitValue = proc.execExternalProcess(script, args);
        if (exitValue == 0) {
            return proc.getInputStream();
        }
        String output = StringUtils.isNotBlank((String)proc.getErrorStream()) ? proc.getErrorStream() : proc.getInputStream();
        logger.error("Execute of " + script + " with params " + paramsPattern + " failed , STDERR : " + output, new String[0]);
        throw new ScriptException("execute the program failed - exit value = " + exitValue + " output: " + output);
    }
}

