/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.config;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.digitool.config.ConfigurationManager;
import com.exlibris.digitool.repository.api.xmlbeans.MdName;
import com.exlibris.digitool.repository.metsConfiguration.MetsConfigurationDocument;
import com.exlibris.digitool.repository.metsConfiguration.MetsMdMapping;
import com.exlibris.digitool.repository.metsConfiguration.MetsUsageMapping;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class MetsConfig {
    public static final String ANY = "any";
    private static final ExLogger log = ExLogger.getExLogger(ConfigurationManager.class);
    private static Hashtable m_metsType2DEtypeMap = new Hashtable();
    private static Hashtable m_deType2MetstypeMap = new Hashtable();
    private static Hashtable m_deType2DeNameMap = new Hashtable();
    private static Hashtable m_viewerExcludeList = new Hashtable();
    private static Hashtable m_metsUsage2DeUsage = new Hashtable();
    private static Hashtable deUsage2metsUsage = new Hashtable();
    private static Hashtable m_metsUsage2DeEntityType = new Hashtable();
    private static Hashtable mdNameToMetsType = new Hashtable();
    private static ArrayList metsCompliantTypes = new ArrayList();
    private static ArrayList fullMetsCompliantTypes = new ArrayList();
    private static float wordConfidenceFilter = 0.0f;
    private static MetsConfig m_instance = null;
    private static MetsConfigurationDocument mcd = null;
    private static final String METS_CONF_FILE = "mets_configuration.xml";
    public static final String PROJ_FRAME = "projFrame";
    public static final String RIGHT_RF = "rightRF";
    public static final String SBS = "SBS";
    public static final String WORKING_PID = "WORKING_PID";
    public static final String PARAM_DOCCHOICE = "DOCCHOICE";
    public static final String PARAM_ACTION = "action";
    public static final String PARAM_VIEWER_URL = "viewer_url";
    public static final String PARAM_SIDE_BY_SIDE = "side_by_side";
    public static final String PARAM_SHOW_METADATA = "show_metadata";
    public static final String PARAM_METADATA_OBJECT_RATIO = "metadata_object_ratio";
    public static final String PARAM_SAME_METADATA = "same_metadata";
    public static final String VALUE_DIFFERENT_METADATA = "DIFFERENT-METADATA";
    public static final String PARAM_RESET_PARAMETERS = "reset_params";
    public static final String PARAM_OBJ_ID = "objID";
    public static final String ATT_USER_CLICKED_ON_MANIFESTATION = "user_clicked_manif";
    public static final String ATT_OBJ_ONLY = "objOnly";
    public static final String ATT_DATA = "data";
    public static final String ATT_DVS = "dvs";
    private static final String METS = "mets";
    public static final String METS_FILEID_PREFIX = "METSID-";

    public static synchronized MetsConfig getInstance() {
        if (m_instance == null) {
            m_instance = new MetsConfig();
            m_instance.load();
        }
        return m_instance;
    }

    public static void reset() {
        m_instance = null;
        m_metsType2DEtypeMap = new Hashtable();
        m_deType2MetstypeMap = new Hashtable();
        m_deType2DeNameMap = new Hashtable();
        m_viewerExcludeList = new Hashtable();
        m_metsUsage2DeUsage = new Hashtable();
        deUsage2metsUsage = new Hashtable();
        m_metsUsage2DeEntityType = new Hashtable();
    }

    public static void main(String[] args) {
        new MetsConfig().load();
    }

    private void load() {
        try {
            log.info("Looking for mets configuration file: mets_configuration.xml ...");
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(METS_CONF_FILE);
            if (in == null) {
                log.error("Mets configuration file not found." + in, new String[0]);
            }
            log.info("Mets configuration file found.");
            mcd = MetsConfigurationDocument.Factory.parse(in);
            this.hashSettings();
            log.info("Mets setting Loaded");
        }
        catch (Throwable e) {
            log.error("Failed to load mets configuration from mets_configuration.xml: " + e.getMessage() + e.getLocalizedMessage() + e.getCause(), new String[0]);
        }
    }

    private void hashSettings() {
        String[] excludes = mcd.getMetsConfiguration().getMetsViewer().getMetsExcludeUsageArray();
        for (int i = 0; i < excludes.length; ++i) {
            m_viewerExcludeList.put(excludes[i].toLowerCase(), new Boolean(true));
        }
        try {
            wordConfidenceFilter = mcd.getMetsConfiguration().getMetsViewer().getWordConfidenceFilter();
        }
        catch (Exception e) {
            wordConfidenceFilter = 0.0f;
            log.warn((Object)"Word Confidence Filter was not configured", new String[0]);
        }
        MetsUsageMapping[] usageMapping = mcd.getMetsConfiguration().getMetsTransformer().getMetsUsageMappingArray();
        for (int i = 0; i < usageMapping.length; ++i) {
            m_metsUsage2DeUsage.put(usageMapping[i].getMets().toLowerCase(), usageMapping[i].getDige());
            if (!deUsage2metsUsage.contains(usageMapping[i].getDige())) {
                String key = usageMapping[i].getDige();
                if (usageMapping[i].getDigeEntityType() != null && usageMapping[i].getDigeEntityType().length() > 0) {
                    key = key + "~" + usageMapping[i].getDigeEntityType();
                }
                deUsage2metsUsage.put(key, usageMapping[i].getMets().toLowerCase());
            }
            if (usageMapping[i].getDigeEntityType() == null) continue;
            m_metsUsage2DeEntityType.put(usageMapping[i].getMets(), usageMapping[i].getDigeEntityType());
        }
        MetsMdMapping[] mdMapping = mcd.getMetsConfiguration().getMetsTransformer().getMetsMdMappingArray();
        for (int i = 0; i < mdMapping.length; ++i) {
            m_deType2DeNameMap.put(mdMapping[i].getDigeType().toLowerCase(), mdMapping[i].getDigeName());
            m_deType2MetstypeMap.put(mdMapping[i].getDigeType().toLowerCase(), mdMapping[i].getMets());
            m_metsType2DEtypeMap.put(mdMapping[i].getMets().toLowerCase(), mdMapping[i].getDigeType());
        }
        String[] metscomp = mcd.getMetsConfiguration().getMetsTransformer().getMetsCompliantEntityTypeArray();
        for (int i = 0; i < metscomp.length; ++i) {
            metsCompliantTypes.add(metscomp[i].toLowerCase());
        }
        fullMetsCompliantTypes = new ArrayList(metsCompliantTypes);
        fullMetsCompliantTypes.add(METS);
        mdNameToMetsType.put(MdName.Member.DESCRIPTIVE.toString(), "desc");
        mdNameToMetsType.put(MdName.Member.METS_CUSTOM_DMD.toString(), "desc");
        mdNameToMetsType.put(MdName.Member.TECHNICAL.toString(), "admin");
        mdNameToMetsType.put(MdName.Member.PRESERVATION.toString(), "admin");
        mdNameToMetsType.put(MdName.Member.ACCESSRIGHTS.toString(), "admin");
        mdNameToMetsType.put(MdName.Member.CHANGEHISTORY.toString(), "admin");
        mdNameToMetsType.put(MdName.Member.COPYRIGHTS.toString(), "admin");
        mdNameToMetsType.put(MdName.Member.METS_CUSTOM_AMD.toString(), "admin");
        mdNameToMetsType.put(MdName.Member.RIGHTS.toString(), "admin");
    }

    public boolean isMetsAdminMd(String mdName) {
        String mtype = (String)mdNameToMetsType.get(mdName);
        return mtype == null || !mtype.equals("desc");
    }

    public String getDeUsageType(String metsUsageType) {
        return (String)m_metsUsage2DeUsage.get(metsUsageType.toLowerCase());
    }

    public String getMetsUsageTypeByDe(String deUsageType) {
        return (String)deUsage2metsUsage.get(deUsageType);
    }

    public String getDeEntityType(String metsUsageType) {
        return (String)m_metsUsage2DeEntityType.get(metsUsageType.toLowerCase());
    }

    public boolean isExcludeFromView(String metsUsageType) {
        Object o = m_viewerExcludeList.get(metsUsageType.toLowerCase());
        return o != null;
    }

    public String getMetsType(String deType) {
        return (String)m_deType2MetstypeMap.get(deType.toLowerCase());
    }

    public String getDeType(String metsType) {
        return (String)m_metsType2DEtypeMap.get(metsType.toLowerCase());
    }

    public String getDeName(String deType) {
        return (String)m_deType2DeNameMap.get(deType.toLowerCase());
    }

    public boolean isMetsCompliant(String entityType) {
        if (entityType == null) {
            return false;
        }
        if (METS.equals(entityType.toLowerCase())) {
            return true;
        }
        return metsCompliantTypes.contains(entityType.toLowerCase());
    }

    public List getMetsCompliantTypes() {
        return fullMetsCompliantTypes;
    }

    public static float getWordConfidenceFilter() {
        return wordConfidenceFilter;
    }
}

