/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.fsutils;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipHandle {
    private static ExLogger logger = ExLogger.getExLogger(ZipHandle.class);
    private byte[] buffer = new byte[2048];
    private ZipOutputStream zip;
    private boolean hasEntries = false;
    private String zipFilename;

    public ZipHandle(String zipFilename) {
        this.zipFilename = zipFilename;
        this.hasEntries = false;
        File file = new File(zipFilename);
        file.getParentFile().mkdirs();
        if (!file.getParentFile().canWrite()) {
            logger.error("cannot write to " + zipFilename, new String[0]);
            throw new RuntimeException("cannot write to " + zipFilename);
        }
    }

    public void close() {
        try {
            this.zip.close();
        }
        catch (Exception e) {
            logger.error("error occured in ZipHandle.close: " + e.getMessage(), new String[0]);
        }
    }

    public boolean addZipEntry(String filePath, String filePathInZip) {
        int bytesRead;
        BufferedInputStream bis;
        if (!this.hasEntries) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(this.zipFilename);
            }
            catch (Exception e) {
                logger.error("cannot write to " + this.zipFilename, new String[0]);
                return false;
            }
            this.zip = new ZipOutputStream(fos);
            this.hasEntries = true;
        }
        ZipEntry entry = new ZipEntry(filePathInZip);
        File file = new File(filePath);
        if (!file.canRead()) {
            logger.error("cannot read from " + filePath, new String[0]);
            return false;
        }
        CRC32 crc = new CRC32();
        try {
            bis = new BufferedInputStream(new FileInputStream(file));
            crc.reset();
            while ((bytesRead = bis.read(this.buffer)) != -1) {
                crc.update(this.buffer, 0, bytesRead);
            }
            bis.close();
        }
        catch (Exception e) {
            logger.error("failed to calculate CRC32 for " + filePath, new String[0]);
            return false;
        }
        try {
            bis = new BufferedInputStream(new FileInputStream(file));
            entry.setMethod(0);
            entry.setCompressedSize(file.length());
            entry.setSize(file.length());
            entry.setCrc(crc.getValue());
            this.zip.putNextEntry(entry);
            while ((bytesRead = bis.read(this.buffer)) != -1) {
                this.zip.write(this.buffer, 0, bytesRead);
            }
            bis.close();
        }
        catch (Exception e) {
            logger.error("failed to write file into zip " + filePath, new String[0]);
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        String[] filesToZip;
        ZipHandle zipUtil = new ZipHandle("C:\\temp\\admin1\\import\\streams\\aaa.zip");
        for (String fileToZip : filesToZip = new String[]{"C:\\temp\\admin\\import\\streams\\file1.txt", "C:\\temp\\admin1\\import\\streams\\file2.txt"}) {
            zipUtil.addZipEntry(fileToZip, fileToZip);
        }
        zipUtil.close();
    }

    public boolean isHasEntries() {
        return this.hasEntries;
    }

    public void setHasEntries(boolean hasEntries) {
        this.hasEntries = hasEntries;
    }
}

