/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.infrastructure.sync;

import com.exlibris.core.infra.common.exceptions.logging.Descriptor;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.sdk.utils.FSUtil;
import com.exlibris.core.sdk.utils.FileUtil;
import com.exlibris.digitool.exceptions.DigitoolException;
import com.exlibris.digitool.infrastructure.oai.OAIHarvester;
import com.exlibris.digitool.infrastructure.oai.OAIRequestFailedException;
import com.exlibris.digitool.infrastructure.oai.OAIResumptionRequestFailedException;
import com.exlibris.digitool.infrastructure.sync.SyncAbstractSourceAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;

public class SyncOAIAdapter
implements SyncAbstractSourceAdapter {
    private SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private String repositoryName = "";
    private String baseURL = "";
    private String metadataPrefix = "";
    private String fromDate = "";
    private String untilDate = "";
    private String setName = "";
    private String[] arrayOfFileNames;
    private String scope = "";
    private String parserClassName = "";
    private String synchronisationName;
    private String collectionHeader = "";
    private String collectionFooter = "";
    private int maxRecordNumber = 1000;
    private int fileIndex = 0;
    private int result;
    private static ExLogger logger;

    @Override
    public void setParams(Map paramsMap) {
        this.repositoryName = (String)paramsMap.get("repository_name");
        this.baseURL = (String)paramsMap.get("base_url");
        this.metadataPrefix = (String)paramsMap.get("metadata_prefix");
        this.fromDate = (String)paramsMap.get("from");
        this.untilDate = (String)paramsMap.get("until");
        this.setName = (String)paramsMap.get("set");
        this.scope = (String)paramsMap.get("scope");
        this.maxRecordNumber = new Integer((String)paramsMap.get("max_record_number"));
        if (this.maxRecordNumber <= 0) {
            this.maxRecordNumber = 1000;
        }
        TimeZone tz = TimeZone.getTimeZone("UTC");
        this.df.setTimeZone(tz);
    }

    @Override
    public int execute() throws DigitoolException {
        OAIHarvester h;
        Date myUntilDate;
        Date myFromDate;
        Iterator iterator = null;
        this.result = 0;
        this.arrayOfFileNames = new String[100];
        String myDate = this.getLastUpdateDate();
        if (myDate != null) {
            this.fromDate = myDate;
            this.untilDate = null;
        }
        try {
            myFromDate = this.parse(this.fromDate);
            myUntilDate = this.untilDate == null ? myFromDate : this.parse(this.untilDate);
        }
        catch (ParseException e) {
            logger.info("Date parse has failed, see more datailes in the attached exception");
            e.printStackTrace();
            return this.result;
        }
        if (this.untilDate == null) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(myUntilDate);
            int i = new Integer(this.scope);
            ((Calendar)cal).add(12, i);
            myUntilDate = cal.getTime();
        }
        logger.info(" Datetime is " + this.toUTC(myFromDate) + " - " + this.toUTC(myUntilDate));
        this.setFormatParameters();
        try {
            h = new OAIHarvester(this.baseURL + "/" + this.repositoryName, this.parserClassName);
        }
        catch (Exception e) {
            throw new DigitoolException(new Descriptor(e.getMessage(), 0L), (Throwable)e);
        }
        try {
            iterator = h.doListRecords(this.metadataPrefix, this.toUTC(myFromDate), this.toUTC(myUntilDate), this.setName);
        }
        catch (OAIRequestFailedException e) {
            logger.info("Fetch operation has failed, see more datailes in the attached exception");
            e.printStackTrace();
            return this.result;
        }
        catch (OAIResumptionRequestFailedException e) {
            logger.info("Some data had not been fetched, see more detailes in the attached exception");
            e.printStackTrace();
            return this.result;
        }
        GregorianCalendar calUntilDate = new GregorianCalendar();
        calUntilDate.setTime(myUntilDate);
        GregorianCalendar calResponseDate = new GregorianCalendar();
        try {
            calResponseDate.setTime(this.parse(h.getResponseDate()));
        }
        catch (ParseException e) {
            logger.info("Date parse has failed, see more datailes in the attached exception");
            e.printStackTrace();
            return this.result;
        }
        if (calUntilDate.before(calResponseDate)) {
            this.setLastUpdateDate(this.toUTC(myUntilDate));
        } else {
            this.setLastUpdateDate(h.getResponseDate());
        }
        if (iterator != null) {
            try {
                this.result = this.writeObjectsToDisk(iterator);
            }
            catch (Exception e) {
                throw new DigitoolException(new Descriptor(e.getMessage(), 0L), (Throwable)e);
            }
        }
        return this.result;
    }

    @Override
    public void setName(String name) {
        this.synchronisationName = name;
    }

    @Override
    public void setLogger(ExLogger l) {
        logger = l;
    }

    @Override
    public String[] getFileNames() {
        return this.arrayOfFileNames;
    }

    private String getFileName() {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'.'hhmmss");
        String fileName = this.synchronisationName + "_" + dateFormat.format(date) + "_" + this.fileIndex + ".xml";
        this.arrayOfFileNames[this.fileIndex++] = fileName;
        logger.info(" Output stream - " + fileName);
        return FSUtil.appendPath(FSUtil.getSynchronisationsFilesDir(), fileName);
    }

    private int writeObjectsToDisk(Iterator iterator) throws IOException, FileNotFoundException, UnsupportedEncodingException {
        int recordIndex = 0;
        int fileCount = 0;
        this.fileIndex = 0;
        String fileName = this.getFileName();
        FileOutputStream f = new FileOutputStream(fileName);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)f, "UTF-8");
        String newline = System.getProperty("line.separator");
        out.write(this.collectionHeader);
        out.write(newline);
        while (iterator.hasNext()) {
            out.write((String)iterator.next());
            out.write(newline);
            ++recordIndex;
            if (++fileCount != this.maxRecordNumber) continue;
            logger.info(" Number of elements in stream " + fileName + " - " + fileCount);
            fileCount = 0;
            out.write(this.collectionFooter);
            out.write(newline);
            out.close();
            fileName = this.getFileName();
            f = new FileOutputStream(fileName);
            out = new OutputStreamWriter((OutputStream)f, "UTF-8");
            out.write(this.collectionHeader);
            out.write(newline);
        }
        out.write(this.collectionFooter);
        out.write(newline);
        out.close();
        if (fileCount == 0) {
            File file = new File(fileName);
            if (file.exists()) {
                logger.info(" Unnecessary output stream - " + fileName + " removed");
                file.delete();
            }
        } else {
            logger.info(" Number of elements in stream " + fileName + " - " + fileCount);
        }
        return recordIndex;
    }

    private void setFormatParameters() {
        if (this.metadataPrefix.equalsIgnoreCase("oai_dc") || this.metadataPrefix.equalsIgnoreCase("dc")) {
            this.parserClassName = "com.exlibris.core.infra.common.oai.OAIDCSaxParser";
            this.collectionHeader = "<records xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\">";
            this.collectionFooter = "</records>";
            return;
        }
        if (this.metadataPrefix.equalsIgnoreCase("marc21")) {
            this.parserClassName = "com.exlibris.core.infra.common.oai.OAIMARCSaxParser";
            this.collectionHeader = "<collection xmlns=\"http://www.loc.gov/MARC21/slim\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd\">";
            this.collectionFooter = "</collection>";
            return;
        }
        this.parserClassName = "com.exlibris.core.infra.common.oai.OAISaxParser";
        this.collectionHeader = "<collection xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
        this.collectionFooter = "</collection>";
    }

    private void setLastUpdateDate(String date) {
        logger.info(" Response Date - " + date);
        try {
            File tsfile = this.getTimeStampFile();
            FileUtil.writeFile(tsfile, date);
        }
        catch (Exception e) {
            logger.error("Could not write timestamp file.", e, new String[0]);
        }
    }

    private File getTimeStampFile() {
        File tsfile = new File(FSUtil.getSynchronisationsTimestampsDir() + this.synchronisationName + ".timestamp");
        return tsfile;
    }

    private String getLastUpdateDate() {
        File tsfile = this.getTimeStampFile();
        if (!tsfile.exists()) {
            logger.info(" No timestamp file found, will reset set.");
            return null;
        }
        try {
            String tsStr = FileUtil.getContents(tsfile);
            return tsStr.substring(0, 20);
        }
        catch (Exception e) {
            logger.warn((Object)"Could not read timestamp file, will reset set.", e, new String[0]);
            return null;
        }
    }

    private Date parse(String input) throws ParseException {
        return this.df.parse(input);
    }

    private String toUTC(Date date) {
        return this.df.format(date);
    }
}

