/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.infrastructure.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class ISO8601DateParser {
    private static SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ssz");

    public static Date parse(String input) throws ParseException {
        if (input.endsWith("Z")) {
            input = input.substring(0, input.length() - 1) + "GMT-00:00";
        } else {
            int inset = 6;
            String s0 = input.substring(0, input.length() - inset);
            String s1 = input.substring(input.length() - inset, input.length());
            input = s0 + "GMT" + s1;
        }
        return df.parse(input);
    }

    public static String toUTC(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss'Z'");
        return dateFormat.format(date);
    }

    public static String toString(Date date) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        df.setTimeZone(tz);
        String output = df.format(date);
        int inset0 = 9;
        int inset1 = 6;
        String s0 = output.substring(0, output.length() - inset0);
        String s1 = output.substring(output.length() - inset1, output.length());
        String result = s0 + s1;
        result = result.replaceAll("UTC", "+00:00");
        return result;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(ISO8601DateParser.parse("2004-05-31T09:19:31-06:00"));
        System.out.println(ISO8601DateParser.parse("2004-06-23T17:25:31-00:00"));
        System.out.println(ISO8601DateParser.parse("2004-06-23T17:25:31Z"));
        System.out.println("v: " + ISO8601DateParser.toString(new Date(System.currentTimeMillis())));
    }
}

