/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.tools;

import com.exlibris.core.infra.common.util.sorter.ExComparator;
import com.exlibris.core.sdk.interfaces.PidWrapper;
import com.exlibris.dps.sdk.deposit.IEUtil;
import gov.loc.mets.StructMapType;
import java.util.ArrayList;
import java.util.HashMap;

public class StructMapComparator
extends ExComparator<PidWrapper> {
    HashMap<String, Integer> structMapOrder;

    public StructMapComparator(StructMapType structMap) {
        this.structMapOrder = this.createHash(structMap);
    }

    @Override
    public int compareObj(PidWrapper file1, PidWrapper file2) {
        Integer idx1 = this.structMapOrder.get(file1.getPid());
        Integer idx2 = this.structMapOrder.get(file2.getPid());
        if (idx1 == null || idx2 == null) {
            return 0;
        }
        return idx1 - idx2;
    }

    private HashMap<String, Integer> createHash(StructMapType structMap) {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        ArrayList<String> files = IEUtil.getFilesArray(structMap);
        for (String file : files) {
            resultMap.put(file, files.indexOf(file));
        }
        return resultMap;
    }
}

