/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.repository.persistence.sip;

import com.exlibris.core.infra.model.DividedDate;
import com.exlibris.core.infra.model.annotation.Searchable;
import com.exlibris.core.infra.model.annotation.emailData;
import com.exlibris.core.sdk.consts.Enum;
import com.exlibris.core.sdk.strings.StringUtils;
import java.io.Serializable;
import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.ColumnResult;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.Transient;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Table;
import org.hibernate.annotations.Type;
import org.hibernate.validator.Length;

@Entity
@javax.persistence.Table(name="SIP_REGISTRY")
@Table(appliesTo="SIP_REGISTRY", indexes={@Index(name="SIP_REGISTRY_JBPM_SIP", columnNames={"JBPM_PROCESS_ID", "SIP_ID"}), @Index(name="EXTERNAL_ID_SYSTEM_IDX", columnNames={"EXTERNAL_ID", "EXTERNAL_SYSTEM"})})
@NamedQueries(value={@NamedQuery(name="getSipByDepositId", query="select reg.sipId from HsSipRegistry reg where reg.depositId = :DEPOSIT_ID")})
@SqlResultSetMapping(name="scalar", columns={@ColumnResult(name="sipsNumber")})
@NamedNativeQueries(value={@NamedNativeQuery(name="findNumberOfSipsForUser", query="SELECT count(distinct(reg.sip_id)) as sipsNumber FROM sip_registry reg WHERE reg.handling_agent  = :userName", resultSetMapping="scalar"), @NamedNativeQuery(name="findSips", query="SELECT reg.* FROM sip_registry reg, jbpm_taskinstance ti WHERE ti.name_ = :taskName and ti.issuspended_ != 1 and ti.isopen_ = 1 and ti.procinst_ = reg.jbpm_process_id", resultClass=HsSipRegistry.class), @NamedNativeQuery(name="findNumberOfSips", query="SELECT count(distinct(reg.sip_id)) as sipsNumber FROM sip_registry reg, jbpm_taskinstance ti WHERE ti.name_ = :taskName and ti.issuspended_ != 1 and ti.isopen_ = 1 and ti.procinst_ = reg.jbpm_process_id", resultSetMapping="scalar")})
public class HsSipRegistry
implements Serializable,
Comparable {
    private static final long serialVersionUID = 1L;
    private Long sipId;
    private String sipDirPath;
    private Long depositId;
    private String batchId;
    private Calendar submitDate;
    private DividedDate submitDateDummy;
    private String procConfId;
    private String stage;
    private SipStatus status;
    private Calendar statusDate;
    private Enum.LifeCycle lifeCycle;
    private String producer;
    private String producerAgent;
    private String approvalGroupId;
    private String metadata;
    private String materialType;
    private String contentStructure;
    private String title;
    private String owner;
    private Calendar relevancyStartDate;
    private String handlingAgent;
    private Calendar handlingDate;
    private String accessRightsId;
    private String externalId;
    private String externalSystem;
    private boolean techAttentionFlag;
    private String techAttentionNote;
    private boolean curatorialAttentionFlag;
    private String curatorialAttentionNote;
    private String internalNote;
    private Long materialFlowId;
    private Long processId;
    private String actionReason;
    private String actionNote;
    private Long jbpmProcessId;
    private Calendar updateDate;
    private String updatedBy;
    private int samplingRate;
    private Byte[] rawData;
    private String indexXml;

    public HsSipRegistry() {
        this.setSubmitDate(this.submitDate);
    }

    @Id
    @Column(name="SIP_ID")
    @Searchable
    @emailData
    public Long getSipId() {
        return this.sipId;
    }

    public void setSipId(Long sipId) {
        this.sipId = sipId;
    }

    @emailData
    @Column(name="SIP_DIR_PATH")
    public String getSipDirPath() {
        return this.sipDirPath;
    }

    public void setSipDirPath(String sipDirPath) {
        this.sipDirPath = sipDirPath;
    }

    @Column(name="DEPOSIT_ID", unique=true)
    @Searchable
    public Long getDepositId() {
        return this.depositId;
    }

    public void setDepositId(Long depositId) {
        this.depositId = depositId;
    }

    @Column(name="BATCH_ID")
    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    @emailData
    @Column(name="SUBMIT_DATE")
    public Calendar getSubmitDate() {
        if (this.submitDate.getTimeInMillis() == 0L) {
            return null;
        }
        return this.submitDate;
    }

    public void setSubmitDate(Calendar submitDate) {
        this.submitDate = submitDate;
        this.submitDateDummy = new DividedDate(this.submitDate);
        this.submitDate = this.submitDateDummy.getCalendar();
    }

    @Transient
    public DividedDate getSubmitDateDummy() {
        return this.submitDateDummy;
    }

    public void setSubmitDateDummy(DividedDate submitDateDummy) {
        this.submitDateDummy = submitDateDummy;
    }

    @Column(name="PROC_CONF_ID")
    @Searchable
    public String getProcConfId() {
        return this.procConfId;
    }

    public void setProcConfId(String procConfId) {
        this.procConfId = procConfId;
    }

    @Column(name="STAGE")
    @Index(name="SIP_REGISTRY_STAGE")
    @Searchable
    @emailData
    public String getStage() {
        return this.stage;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }

    @Column(name="STATUS", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @Index(name="SIP_REGISTRY_STATUS")
    @Searchable
    @emailData
    public SipStatus getStatus() {
        return this.status;
    }

    public void setStatus(SipStatus status) {
        this.status = status;
    }

    @Transient
    public String getSipSipStatus() {
        return this.status.toString();
    }

    public void setSipSipStatus(String sipSipStatus) {
        this.status = SipStatus.valueOf(sipSipStatus);
    }

    @emailData
    @Column(name="STATUS_DATE")
    public Calendar getStatusDate() {
        return this.statusDate;
    }

    public void setStatusDate(Calendar statusDate) {
        this.statusDate = statusDate;
    }

    @Column(name="LIFE_CYCLE")
    @Enumerated(value=EnumType.STRING)
    @Searchable
    @emailData
    public Enum.LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    public void setLifeCycle(Enum.LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    @Column(name="PRODUCER")
    @Searchable
    public String getProducer() {
        return this.producer;
    }

    public void setProducer(String producer) {
        this.producer = producer;
    }

    @Column(name="PRODUCER_AGENT")
    @Searchable
    public String getProducerAgent() {
        return this.producerAgent;
    }

    public void setProducerAgent(String producerAgent) {
        this.producerAgent = producerAgent;
    }

    @Column(name="APPROVAL_GROUP_ID")
    @Searchable
    @emailData
    public String getApprovalGroupId() {
        return this.approvalGroupId;
    }

    public void setApprovalGroupId(String approvalGroupId) {
        this.approvalGroupId = approvalGroupId;
    }

    @Column(name="METADATA")
    @Lob
    public String getZmetadata() {
        return this.metadata;
    }

    public void setZmetadata(String metadata) {
        this.metadata = metadata;
    }

    @Column(name="MATERIAL_TYPE")
    @Searchable
    public String getMaterialType() {
        return this.materialType;
    }

    public void setMaterialType(String materialType) {
        this.materialType = materialType;
    }

    @Column(name="CONTENT_STRUCTURE")
    @Searchable
    @emailData
    public String getContentStructure() {
        return this.contentStructure;
    }

    public void setContentStructure(String contentStructure) {
        this.contentStructure = contentStructure;
    }

    @Column(name="TITLE", length=4000)
    @Searchable
    @emailData
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        int length = StringUtils.getNullSafeLength(title);
        String newString = StringUtils.getLimitedLengthString(title, 4000);
        this.title = length < 1333 ? newString : StringUtils.getLimitedUTF8LengthString(newString, 4000);
    }

    @Column(name="OWNER")
    @Searchable
    @emailData
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Column(name="RELEVANCY_START_DATE")
    public Calendar getRelevancyStartDate() {
        return this.relevancyStartDate;
    }

    public void setRelevancyStartDate(Calendar relevancyStartDate) {
        this.relevancyStartDate = relevancyStartDate;
    }

    @Column(name="HANDLING_AGENT")
    @Searchable
    @emailData
    public String getHandlingAgent() {
        return this.handlingAgent;
    }

    public void setHandlingAgent(String handlingAgent) {
        this.handlingAgent = handlingAgent;
    }

    @emailData
    @Column(name="HANDLING_DATE")
    public Calendar getHandlingDate() {
        return this.handlingDate;
    }

    public void setHandlingDate(Calendar handlingDate) {
        this.handlingDate = handlingDate;
    }

    @Column(name="access_rights_id")
    public String getAccessRightsId() {
        return this.accessRightsId;
    }

    public void setAccessRightsId(String accessRightsId) {
        this.accessRightsId = accessRightsId;
    }

    @Column(name="TECH_ATTENTION_FLAG")
    @Searchable
    @emailData
    public boolean isTechAttentionFlag() {
        return this.techAttentionFlag;
    }

    public void setTechAttentionFlag(boolean techAttentionFlag) {
        this.techAttentionFlag = techAttentionFlag;
    }

    @Column(name="TECH_ATTENTION_NOTE")
    @Searchable
    @emailData
    public String getTechAttentionNote() {
        return this.techAttentionNote;
    }

    public void setTechAttentionNote(String techAttentionNote) {
        this.techAttentionNote = techAttentionNote;
    }

    @Column(name="CURATORIAL_ATTENTION_FLAG")
    @Searchable
    @emailData
    public boolean isCuratorialAttentionFlag() {
        return this.curatorialAttentionFlag;
    }

    public void setCuratorialAttentionFlag(boolean curatorialAttentionFlag) {
        this.curatorialAttentionFlag = curatorialAttentionFlag;
    }

    @Column(name="CURATORIAL_ATTENTION_NOTE", length=4000)
    @Searchable
    @emailData
    public String getCuratorialAttentionNote() {
        return this.curatorialAttentionNote;
    }

    public void setCuratorialAttentionNote(String curatorialAttentionNote) {
        this.curatorialAttentionNote = curatorialAttentionNote;
    }

    @Column(name="INTERNAL_NOTE")
    @Searchable
    @emailData
    public String getInternalNote() {
        return this.internalNote;
    }

    public void setInternalNote(String internalNote) {
        this.internalNote = internalNote;
    }

    @Column(name="MATERIAL_FLOW_ID")
    @Index(name="SIP_REGISTRY_MATERIAL_FLOW_ID")
    @Searchable
    public Long getMaterialFlowId() {
        return this.materialFlowId;
    }

    public void setMaterialFlowId(Long materialFlowId) {
        this.materialFlowId = materialFlowId;
    }

    @Column(name="PROCESS_ID")
    @Searchable
    public Long getProcessId() {
        return this.processId;
    }

    public void setProcessId(Long processId) {
        this.processId = processId;
    }

    @Column(name="ACTION_REASON")
    @Searchable
    @emailData
    public String getActionReason() {
        return this.actionReason;
    }

    public void setActionReason(String actionReason) {
        this.actionReason = actionReason;
    }

    @Column(name="ACTION_NOTE")
    @Length(max=2048)
    @Searchable
    @emailData
    public String getActionNote() {
        return this.actionNote;
    }

    public void setActionNote(String actionNote) {
        this.actionNote = actionNote;
    }

    @Column(name="JBPM_PROCESS_ID")
    @Index(name="SIP_REGISTRY_JBPM_PROCESS_ID")
    @Searchable
    public Long getJbpmProcessId() {
        return this.jbpmProcessId;
    }

    public void setJbpmProcessId(Long jbpmProcessId) {
        this.jbpmProcessId = jbpmProcessId;
    }

    @emailData
    @Column(name="UPDATE_DATE")
    public Calendar getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Calendar updateDate) {
        this.updateDate = updateDate;
    }

    @Column(name="UPDATED_BY")
    @Searchable
    @emailData
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    @Column(name="SAMPLING_RATE")
    @Searchable
    public int getSamplingRate() {
        return this.samplingRate;
    }

    public void setSamplingRate(int samplingRate) {
        this.samplingRate = samplingRate;
    }

    @Column(name="EXTERNAL_ID")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @Column(name="EXTERNAL_SYSTEM")
    public String getExternalSystem() {
        return this.externalSystem;
    }

    public void setExternalSystem(String externalSystem) {
        this.externalSystem = externalSystem;
    }

    @Column(name="RAW_DATA")
    @Lob
    @Type(type="org.hibernate.type.ByteArrayBlobType")
    public Byte[] getZrawData() {
        return this.rawData;
    }

    @Column(name="index_xml")
    @Lob
    public String getZindexXml() {
        return this.indexXml;
    }

    public void setZindexXml(String indexXml) {
        this.indexXml = indexXml;
    }

    public void setZrawData(Byte[] rawData) {
        this.rawData = rawData;
    }

    public int compareTo(Object o) {
        if (o instanceof HsSipRegistry) {
            HsSipRegistry reg = (HsSipRegistry)o;
            if (this.getSipId() < reg.getSipId()) {
                return -1;
            }
            if (this.getSipId() != null && this.getSipId().equals(reg.getSipId())) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sipId == null ? 0 : this.sipId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HsSipRegistry other = (HsSipRegistry)obj;
        if (this.sipId == null) {
            return other.sipId == null;
        }
        return this.sipId.equals(other.sipId);
    }

    public String toString() {
        String clsname = this.getClass().getSimpleName();
        StringBuffer buffer = new StringBuffer(clsname.length() + 20);
        buffer.append(clsname);
        buffer.append("(");
        buffer.append(this.getSipId());
        buffer.append(")");
        return buffer.toString();
    }

    @Transient
    public String getMetadata() {
        return this.getZmetadata();
    }

    public void setMetadata(String metadata) {
        this.setZmetadata(metadata);
    }

    @Transient
    public Byte[] getRawData() {
        return this.getZrawData();
    }

    public void setRawData(Byte[] rawData) {
        this.setZrawData(rawData);
    }

    @Transient
    public String getIndexXml() {
        return this.getZindexXml();
    }

    public void setIndexXml(String indexXml) {
        this.setZindexXml(indexXml);
    }

    public static enum SipStatus {
        CREATED,
        WAITING,
        ACTIVE,
        REJECT,
        DECLINE,
        REJECT_CONTENT,
        FINISHED,
        IN_HUMAN_STAGE,
        IN_TA;

    }
}

