/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.annotations;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.LiteralStringObject;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.StateManager;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.Appearance;
import org.icepdf.core.pobjects.annotations.AppearanceState;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.graphics.commands.AlphaDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.ColorDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.DrawCmd;
import org.icepdf.core.pobjects.graphics.commands.DrawDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.FillDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.GraphicsStateCmd;
import org.icepdf.core.pobjects.graphics.commands.PostScriptEncoder;
import org.icepdf.core.pobjects.graphics.commands.ShapeDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.StrokeDrawCmd;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextMarkupAnnotation
extends MarkupAnnotation {
    private static final Logger logger;
    public static final Name SUBTYPE_HIGHLIGHT;
    public static final Name SUBTYPE_UNDERLINE;
    public static final Name SUBTYPE_SQUIGGLY;
    public static final Name SUBTYPE_STRIKE_OUT;
    private static Color highlightColor;
    private static Color strikeOutColor;
    private static Color underlineColor;
    public static final Name KEY_QUAD_POINTS;
    public static final int HIGHLIGHT_ALPHA = 80;
    private Shape[] quadrilaterals;
    private Color textMarkupColor;
    private GeneralPath markupPath;
    private ArrayList<Shape> markupBounds;

    public TextMarkupAnnotation(Library l, HashMap h) {
        super(l, h);
    }

    @Override
    public void init() throws InterruptedException {
        super.init();
        List quadPoints = this.library.getArray(this.entries, KEY_QUAD_POINTS);
        if (quadPoints != null) {
            int size = quadPoints.size() / 8;
            this.quadrilaterals = new Shape[size];
            int i = 0;
            int count = 0;
            while (i < size) {
                GeneralPath shape = new GeneralPath(0, 4);
                shape.moveTo(((Number)quadPoints.get(count + 6)).floatValue(), ((Number)quadPoints.get(count + 7)).floatValue());
                shape.lineTo(((Number)quadPoints.get(count + 4)).floatValue(), ((Number)quadPoints.get(count + 5)).floatValue());
                shape.lineTo(((Number)quadPoints.get(count)).floatValue(), ((Number)quadPoints.get(count + 1)).floatValue());
                shape.lineTo(((Number)quadPoints.get(count + 2)).floatValue(), ((Number)quadPoints.get(count + 3)).floatValue());
                shape.closePath();
                this.quadrilaterals[i] = shape;
                ++i;
                count += 8;
            }
        }
        if (SUBTYPE_HIGHLIGHT.equals(this.subtype)) {
            this.textMarkupColor = highlightColor;
        } else if (SUBTYPE_STRIKE_OUT.equals(this.subtype)) {
            this.textMarkupColor = strikeOutColor;
        } else if (SUBTYPE_UNDERLINE.equals(this.subtype)) {
            this.textMarkupColor = underlineColor;
        } else if (SUBTYPE_SQUIGGLY.equals(this.subtype)) {
            // empty if block
        }
        Appearance appearance = (Appearance)this.appearances.get(this.currentAppearance);
        AppearanceState appearanceState = appearance.getSelectedAppearanceState();
        Shapes shapes = appearanceState.getShapes();
        if (shapes != null) {
            this.markupBounds = new ArrayList();
            this.markupPath = new GeneralPath();
            for (DrawCmd cmd : shapes.getShapes()) {
                if (!(cmd instanceof ShapeDrawCmd)) continue;
                ShapeDrawCmd shapeDrawCmd = (ShapeDrawCmd)cmd;
                this.markupBounds.add(shapeDrawCmd.getShape());
                this.markupPath.append(shapeDrawCmd.getShape(), false);
            }
        }
        this.resetNullAppearanceStream();
    }

    public static TextMarkupAnnotation getInstance(Library library, Rectangle rect, Name subType) {
        StateManager stateManager = library.getStateManager();
        HashMap<Name, Object> entries = new HashMap<Name, Object>();
        entries.put(Dictionary.TYPE_KEY, Annotation.TYPE_VALUE);
        entries.put(Dictionary.SUBTYPE_KEY, subType);
        entries.put(Annotation.FLAG_KEY, 4);
        if (rect != null) {
            entries.put(Annotation.RECTANGLE_KEY, PRectangle.getPRectangleVector(rect));
        } else {
            entries.put(Annotation.RECTANGLE_KEY, new Rectangle(10, 10, 50, 100));
        }
        TextMarkupAnnotation textMarkupAnnotation = null;
        try {
            textMarkupAnnotation = new TextMarkupAnnotation(library, entries);
            textMarkupAnnotation.init();
            entries.put(NM_KEY, new LiteralStringObject(String.valueOf(textMarkupAnnotation.hashCode())));
            textMarkupAnnotation.setPObjectReference(stateManager.getNewReferencNumber());
            textMarkupAnnotation.setNew(true);
            textMarkupAnnotation.setModifiedDate(PDate.formatDateTime(new Date()));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.fine("Text markup annotation instance creation was interrupted");
        }
        return textMarkupAnnotation;
    }

    public static boolean isTextMarkupAnnotation(Name subType) {
        return SUBTYPE_HIGHLIGHT.equals(subType) || SUBTYPE_UNDERLINE.equals(subType) || SUBTYPE_SQUIGGLY.equals(subType) || SUBTYPE_STRIKE_OUT.equals(subType);
    }

    @Override
    public void resetAppearanceStream(double dx, double dy, AffineTransform pageTransform) {
        Rectangle2D bound;
        if (this.markupBounds == null) {
            return;
        }
        Appearance appearance = (Appearance)this.appearances.get(this.currentAppearance);
        AppearanceState appearanceState = appearance.getSelectedAppearanceState();
        appearanceState.setShapes(new Shapes());
        Rectangle2D bbox = appearanceState.getBbox();
        AffineTransform matrix = appearanceState.getMatrix();
        Shapes shapes = appearanceState.getShapes();
        BasicStroke stroke = new BasicStroke(1.0f);
        shapes.add(new StrokeDrawCmd(stroke));
        shapes.add(new GraphicsStateCmd(EXT_GSTATE_NAME));
        shapes.add(new AlphaDrawCmd(AlphaComposite.getInstance(3, this.opacity)));
        if (SUBTYPE_HIGHLIGHT.equals(this.subtype)) {
            shapes.add(new ShapeDrawCmd(this.markupPath));
            shapes.add(new ColorDrawCmd(this.textMarkupColor));
            shapes.add(new FillDrawCmd());
            shapes.add(new AlphaDrawCmd(AlphaComposite.getInstance(3, 1.0f)));
        } else if (SUBTYPE_STRIKE_OUT.equals(this.subtype)) {
            for (Shape shape : this.markupBounds) {
                GeneralPath strikeOutPath = new GeneralPath();
                bound = shape.getBounds2D();
                float y = (float)(bound.getMinY() + bound.getHeight() / 2.0);
                strikeOutPath.moveTo((float)bound.getMinX(), y);
                strikeOutPath.lineTo((float)bound.getMaxX(), y);
                strikeOutPath.closePath();
                shapes.add(new ShapeDrawCmd(strikeOutPath));
                shapes.add(new ColorDrawCmd(this.textMarkupColor));
                shapes.add(new DrawDrawCmd());
            }
        } else if (SUBTYPE_UNDERLINE.equals(this.subtype)) {
            for (Shape shape : this.markupBounds) {
                GeneralPath underlinePath = new GeneralPath();
                bound = shape.getBounds2D();
                underlinePath.moveTo((float)bound.getMinX(), (float)bound.getMinY());
                underlinePath.lineTo((float)bound.getMaxX(), (float)bound.getMinY());
                underlinePath.closePath();
                shapes.add(new ShapeDrawCmd(underlinePath));
                shapes.add(new ColorDrawCmd(this.textMarkupColor));
                shapes.add(new DrawDrawCmd());
            }
        } else if (SUBTYPE_SQUIGGLY.equals(this.subtype)) {
            // empty if block
        }
        shapes.add(new AlphaDrawCmd(AlphaComposite.getInstance(3, 1.0f)));
        ArrayList<Float> quadPoints = new ArrayList<Float>();
        if (this.markupBounds != null) {
            for (Shape shape : this.markupBounds) {
                Rectangle2D bounds = shape.getBounds2D();
                quadPoints.add(Float.valueOf((float)bounds.getX()));
                quadPoints.add(Float.valueOf((float)(bounds.getY() + bounds.getHeight())));
                quadPoints.add(Float.valueOf((float)(bounds.getX() + bounds.getWidth())));
                quadPoints.add(Float.valueOf((float)(bounds.getY() + bounds.getHeight())));
                quadPoints.add(Float.valueOf((float)bounds.getX()));
                quadPoints.add(Float.valueOf((float)bounds.getY()));
                quadPoints.add(Float.valueOf((float)(bounds.getX() + bounds.getWidth())));
                quadPoints.add(Float.valueOf((float)bounds.getY()));
            }
        }
        this.entries.put(KEY_QUAD_POINTS, quadPoints);
        this.setModifiedDate(PDate.formatDateTime(new Date()));
        Form form = this.updateAppearanceStream(shapes, bbox, matrix, PostScriptEncoder.generatePostScript(shapes.getShapes()));
        TextMarkupAnnotation.generateExternalGraphicsState(form, this.opacity);
    }

    @Override
    protected void renderAppearanceStream(Graphics2D g) {
        Appearance appearance = (Appearance)this.appearances.get(this.currentAppearance);
        AppearanceState appearanceState = appearance.getSelectedAppearanceState();
        Shapes shapes = appearanceState.getShapes();
        if (shapes != null) {
            super.renderAppearanceStream(g);
        } else if (this.quadrilaterals != null) {
            if (this.subtype != null && SUBTYPE_HIGHLIGHT.equals(this.subtype)) {
                g.setComposite(AlphaComposite.getInstance(3, 0.3f));
                if (shapes != null) {
                    shapes.setPaintAlpha(false);
                }
            }
            Object tmp = this.getObject(RECTANGLE_KEY);
            Rectangle2D.Float rectangle = null;
            if (tmp instanceof List) {
                rectangle = this.library.getRectangle(this.entries, RECTANGLE_KEY);
            }
            Rectangle2D.Float origRect = this.getUserSpaceRectangle();
            AffineTransform af = g.getTransform();
            double x = rectangle.getX() - origRect.getX();
            double y = rectangle.getY() - origRect.getY();
            af.translate(-origRect.getX(), -origRect.getY());
            g.setTransform(af);
            g.setColor(highlightColor);
            AffineTransform af2 = new AffineTransform();
            af2.translate(-x, -y);
            for (Shape shape : this.quadrilaterals) {
                g.fill(af2.createTransformedShape(shape));
            }
            if (this.subtype != null && SUBTYPE_HIGHLIGHT.equals(this.subtype)) {
                g.setComposite(AlphaComposite.getInstance(3, 1.0f));
                if (shapes != null) {
                    shapes.setPaintAlpha(true);
                }
            }
        }
    }

    public void setMarkupPath(GeneralPath markupPath) {
        this.markupPath = markupPath;
    }

    public GeneralPath getMarkupPath() {
        return this.markupPath;
    }

    public void setMarkupBounds(ArrayList<Shape> markupBounds) {
        this.markupBounds = markupBounds;
    }

    public Color getTextMarkupColor() {
        return this.textMarkupColor;
    }

    public void setTextMarkupColor(Color textMarkupColor) {
        this.textMarkupColor = textMarkupColor;
    }

    static {
        block8: {
            int colorValue;
            String color;
            block7: {
                block6: {
                    logger = Logger.getLogger(TextMarkupAnnotation.class.toString());
                    SUBTYPE_HIGHLIGHT = new Name("Highlight");
                    SUBTYPE_UNDERLINE = new Name("Underline");
                    SUBTYPE_SQUIGGLY = new Name("Squiggly");
                    SUBTYPE_STRIKE_OUT = new Name("StrikeOut");
                    try {
                        color = Defs.sysProperty("org.icepdf.core.views.page.annotation.textmarkup.highlight.color", "#ffff00");
                        colorValue = ColorUtil.convertColor(color);
                        highlightColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("ffff00", 16));
                    }
                    catch (NumberFormatException e) {
                        if (!logger.isLoggable(Level.WARNING)) break block6;
                        logger.warning("Error reading Text Markup Annotation highlight colour");
                    }
                }
                try {
                    color = Defs.sysProperty("org.icepdf.core.views.page.annotation.textmarkup.strikeOut.color", "#ff0000");
                    colorValue = ColorUtil.convertColor(color);
                    strikeOutColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("ff0000", 16));
                }
                catch (NumberFormatException e) {
                    if (!logger.isLoggable(Level.WARNING)) break block7;
                    logger.warning("Error reading Text Markup Annotation strike out colour");
                }
            }
            try {
                color = Defs.sysProperty("org.icepdf.core.views.page.annotation.textmarkup.underline.color", "#00ff00");
                colorValue = ColorUtil.convertColor(color);
                underlineColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("00ff00", 16));
            }
            catch (NumberFormatException e) {
                if (!logger.isLoggable(Level.WARNING)) break block8;
                logger.warning("Error reading Text Markup Annotation underline colour");
            }
        }
        KEY_QUAD_POINTS = new Name("QuadPoints");
    }
}

