/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.compiler.regex;

import net.byteseek.automata.State;
import net.byteseek.automata.Transition;
import net.byteseek.automata.factory.TransitionFactory;
import net.byteseek.compiler.matcher.MatcherCompilerUtils;
import net.byteseek.matcher.automata.ByteMatcherTransition;
import net.byteseek.matcher.bytes.ByteMatcherFactory;
import net.byteseek.matcher.bytes.OptimalByteMatcherFactory;
import net.byteseek.parser.ParseException;
import net.byteseek.parser.tree.ParseTree;

public final class ParseTreeTransitionFactory<T>
implements TransitionFactory<T, ParseTree> {
    private final ByteMatcherFactory matcherFactory;

    public ParseTreeTransitionFactory() {
        this(null);
    }

    public ParseTreeTransitionFactory(ByteMatcherFactory matcherFactory) {
        this.matcherFactory = matcherFactory == null ? OptimalByteMatcherFactory.FACTORY : matcherFactory;
    }

    @Override
    public Transition<T> create(ParseTree source, boolean invert, State<T> toState) {
        try {
            switch (source.getParseTreeType()) {
                case BYTE: {
                    return this.createByteTransition(source, toState);
                }
                case ALL_BITMASK: {
                    return this.createAllBitmaskTransition(source, toState);
                }
                case ANY_BITMASK: {
                    return this.createAnyBitmaskTransition(source, toState);
                }
                case ANY: {
                    return this.createAnyTransition(source, toState);
                }
                case RANGE: {
                    return this.createRangeTransition(source, toState);
                }
                case SET: {
                    return this.createSetTransition(source, toState);
                }
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return null;
    }

    private Transition<T> createByteTransition(ParseTree ast, State<T> toState) throws ParseException {
        return new ByteMatcherTransition<T>(MatcherCompilerUtils.createByteMatcher(ast), toState);
    }

    private Transition<T> createAllBitmaskTransition(ParseTree ast, State<T> toState) throws ParseException {
        return new ByteMatcherTransition<T>(MatcherCompilerUtils.createAllBitmaskMatcher(ast), toState);
    }

    private Transition<T> createAnyBitmaskTransition(ParseTree ast, State<T> toState) throws ParseException {
        return new ByteMatcherTransition<T>(MatcherCompilerUtils.createAnyBitmaskMatcher(ast), toState);
    }

    private Transition<T> createAnyTransition(ParseTree ast, State<T> toState) throws ParseException {
        return new ByteMatcherTransition<T>(MatcherCompilerUtils.createAnyMatcher(ast), toState);
    }

    private Transition<T> createRangeTransition(ParseTree ast, State<T> toState) throws ParseException {
        return new ByteMatcherTransition<T>(MatcherCompilerUtils.createRangeMatcher(ast), toState);
    }

    private Transition<T> createSetTransition(ParseTree ast, State<T> toState) throws ParseException {
        return new ByteMatcherTransition<T>(MatcherCompilerUtils.createMatcherFromSet(ast, this.matcherFactory), toState);
    }
}

