/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public final class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private IOUtils() {
    }

    public static int readBytes(InputStream input, byte[] bytes) throws IOException {
        int totalRead;
        int read;
        int blockSize = bytes.length;
        for (totalRead = 0; totalRead < blockSize && (read = input.read(bytes, totalRead, blockSize - totalRead)) != -1; totalRead += read) {
        }
        return totalRead;
    }

    public static int readBytes(RandomAccessFile input, byte[] bytes) throws IOException {
        int totalRead;
        int read;
        int blockSize = bytes.length;
        for (totalRead = 0; totalRead < blockSize && (read = input.read(bytes, totalRead, blockSize - totalRead)) != -1; totalRead += read) {
        }
        return totalRead;
    }

    public static int readBytes(RandomAccessFile input, byte[] bytes, long fromPosition) throws IOException {
        int totalRead;
        int read;
        int blockSize = bytes.length;
        input.seek(fromPosition);
        for (totalRead = 0; totalRead < blockSize && (read = input.read(bytes, totalRead, blockSize - totalRead)) != -1; totalRead += read) {
        }
        return totalRead;
    }

    public static void writeBytes(RandomAccessFile output, byte[] bytes, long atPosition) throws IOException {
        output.seek(atPosition);
        output.write(bytes);
    }

    public static File createTempFile() throws IOException {
        return File.createTempFile("byteseek", ".tmp");
    }

    public static File createTempFile(File tempDir) throws IOException {
        return File.createTempFile("byteseek", ".tmp", tempDir);
    }

    public static File createTempFile(InputStream in) throws IOException {
        return IOUtils.createTempFile(in, 4096);
    }

    public static File createTempFile(InputStream in, int bufferSize) throws IOException {
        File tempFile = IOUtils.createTempFile();
        FileOutputStream out = new FileOutputStream(tempFile);
        IOUtils.copyStream(in, out, bufferSize);
        out.close();
        return tempFile;
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        IOUtils.copyStream(in, out, 4096);
    }

    public static void copyStream(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int byteRead;
        byte[] buffer = new byte[bufferSize];
        while ((byteRead = in.read(buffer)) >= 0) {
            out.write(buffer, 0, byteRead);
        }
    }
}

