/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.io.reader;

import java.io.IOException;
import net.byteseek.io.reader.AbstractReader;
import net.byteseek.io.reader.cache.NoCache;
import net.byteseek.io.reader.windows.HardWindow;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.utils.ArgUtils;

public class ByteArrayReader
extends AbstractReader {
    private final byte[] bytes;

    public ByteArrayReader(byte[] bytes) {
        super(bytes == null ? 0 : bytes.length, NoCache.NO_CACHE);
        ArgUtils.checkNullObject(bytes, "bytes");
        this.bytes = bytes;
    }

    public ByteArrayReader(byte byteValue) {
        super(1, NoCache.NO_CACHE);
        this.bytes = new byte[]{byteValue};
    }

    @Override
    protected Window createWindow(long windowStart) throws IOException {
        return windowStart == 0L ? new HardWindow(this.bytes, 0L, this.bytes.length) : null;
    }

    @Override
    public long length() throws IOException {
        return this.bytes.length;
    }

    public byte[] getByteArray() {
        return this.bytes;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[length:" + this.bytes.length + " cache:" + this.cache + ']';
    }
}

