/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.matcher.bytes;

import java.io.IOException;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.matcher.bytes.AbstractByteMatcher;
import net.byteseek.matcher.sequence.FixedGapMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.utils.ArgUtils;
import net.byteseek.utils.ByteUtils;

public final class AnyByteMatcher
extends AbstractByteMatcher {
    public static final AnyByteMatcher ANY_BYTE_MATCHER = new AnyByteMatcher();
    private static final byte[] ALL_BYTES = ByteUtils.getAllByteValues();

    @Override
    public boolean matches(byte theByte) {
        return true;
    }

    @Override
    public byte[] getMatchingBytes() {
        return (byte[])ALL_BYTES.clone();
    }

    @Override
    public String toRegularExpression(boolean prettyPrint) {
        return ".";
    }

    @Override
    public boolean matches(WindowReader reader, long matchPosition) throws IOException {
        return reader.readByte(matchPosition) >= 0;
    }

    @Override
    public boolean matches(byte[] bytes, int matchPosition) {
        return matchPosition >= 0 && matchPosition < bytes.length;
    }

    @Override
    public int getNumberOfMatchingBytes() {
        return 256;
    }

    @Override
    public boolean matchesNoBoundsCheck(byte[] bytes, int matchPosition) {
        return true;
    }

    @Override
    public SequenceMatcher repeat(int numberOfRepeats) {
        ArgUtils.checkPositiveInteger(numberOfRepeats, "numberOfRepeatss");
        if (numberOfRepeats == 1) {
            return this;
        }
        return new FixedGapMatcher(numberOfRepeats);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

