/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.matcher.sequence;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.bytes.ByteMatcher;
import net.byteseek.matcher.bytes.OneByteMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.utils.ArgUtils;
import net.byteseek.utils.ByteUtils;

public final class ByteMatcherSequenceMatcher
implements SequenceMatcher {
    private final int length;
    private final int startArrayIndex;
    private final int endArrayIndex;
    private final ByteMatcher[] matchers;

    public ByteMatcherSequenceMatcher(byte ... bytes) {
        this(1, bytes, 0, bytes == null ? -1 : bytes.length);
    }

    public ByteMatcherSequenceMatcher(int repeats, byte byteValue) {
        this(repeats, (ByteMatcher)OneByteMatcher.valueOf(byteValue));
    }

    public ByteMatcherSequenceMatcher(int repeats, ByteMatcher matcher) {
        ArgUtils.checkPositiveInteger(repeats);
        ArgUtils.checkNullObject(matcher);
        this.length = repeats;
        this.startArrayIndex = 0;
        this.endArrayIndex = this.length;
        this.matchers = new ByteMatcher[this.length];
        Arrays.fill(this.matchers, matcher);
    }

    public ByteMatcherSequenceMatcher(String string) {
        this(string, Charset.defaultCharset());
    }

    public ByteMatcherSequenceMatcher(String string, Charset charset) {
        ArgUtils.checkNullOrEmptyString(string, "string");
        ArgUtils.checkNullObject(charset, "charset");
        byte[] bytes = string.getBytes(charset);
        this.length = bytes.length;
        this.startArrayIndex = 0;
        this.endArrayIndex = this.length;
        this.matchers = new ByteMatcher[this.length];
        this.populateMatchers(1, bytes, 0, this.length);
    }

    public ByteMatcherSequenceMatcher(int repeats, byte[] array) {
        this(repeats, array, 0, array == null ? -1 : array.length);
    }

    public ByteMatcherSequenceMatcher(byte[] array, int startIndex, int endIndex) {
        this(1, array, startIndex, endIndex);
    }

    public ByteMatcherSequenceMatcher(int repeats, byte[] array, int startIndex, int endIndex) {
        ArgUtils.checkPositiveInteger(repeats, "repeats");
        ArgUtils.checkNullOrEmptyByteArray(array);
        ArgUtils.checkIndexOutOfBounds(array.length, startIndex, endIndex);
        this.length = (endIndex - startIndex) * repeats;
        this.startArrayIndex = 0;
        this.endArrayIndex = this.length;
        this.matchers = new ByteMatcher[this.length];
        this.populateMatchers(repeats, array, startIndex, endIndex);
    }

    public ByteMatcherSequenceMatcher(ByteMatcher ... sequence) {
        this(1, sequence, 0, sequence == null ? -1 : sequence.length);
    }

    public ByteMatcherSequenceMatcher(int repeats, ByteMatcher[] sequence) {
        this(repeats, sequence, 0, sequence == null ? -1 : sequence.length);
    }

    public ByteMatcherSequenceMatcher(ByteMatcher[] sequence, int startIndex, int endIndex) {
        this(1, sequence, startIndex, endIndex);
    }

    public ByteMatcherSequenceMatcher(int repeats, ByteMatcher[] sequence, int startIndex, int endIndex) {
        ArgUtils.checkPositiveInteger(repeats);
        ArgUtils.checkNullOrEmptyArrayNoNullElements(sequence);
        ArgUtils.checkIndexOutOfBounds(sequence.length, startIndex, endIndex);
        this.length = (endIndex - startIndex) * repeats;
        this.startArrayIndex = 0;
        this.endArrayIndex = this.length;
        this.matchers = new ByteMatcher[this.length];
        this.populateMatchers(repeats, sequence, startIndex, endIndex);
    }

    public ByteMatcherSequenceMatcher(int repeats, ByteMatcherSequenceMatcher source) {
        this(repeats, source, 0, source == null ? -1 : source.length);
    }

    public ByteMatcherSequenceMatcher(ByteMatcherSequenceMatcher matcher, int startIndex, int endIndex) {
        this(1, matcher, startIndex, endIndex);
    }

    public ByteMatcherSequenceMatcher(int repeats, ByteMatcherSequenceMatcher source, int startIndex, int endIndex) {
        ArgUtils.checkPositiveInteger(repeats);
        ArgUtils.checkNullObject(source);
        ArgUtils.checkIndexOutOfBounds(source.length, startIndex, endIndex);
        this.length = (endIndex - startIndex) * repeats;
        if (repeats == 1) {
            this.startArrayIndex = source.startArrayIndex + startIndex;
            this.endArrayIndex = source.startArrayIndex + endIndex;
            this.matchers = source.matchers;
        } else {
            this.startArrayIndex = 0;
            this.endArrayIndex = this.length;
            this.matchers = new ByteMatcher[this.length];
            this.populateMatchers(repeats, source, startIndex, endIndex);
        }
    }

    public ByteMatcherSequenceMatcher(ByteMatcherSequenceMatcher ... matchers) {
        ArgUtils.checkNullOrEmptyArrayNoNullElements(matchers);
        if (matchers.length == 1) {
            ByteMatcherSequenceMatcher theMatcher = matchers[0];
            this.length = theMatcher.length;
            this.startArrayIndex = theMatcher.startArrayIndex;
            this.endArrayIndex = theMatcher.endArrayIndex;
            this.matchers = theMatcher.matchers;
        } else {
            this.length = this.countTotalLength(matchers);
            this.startArrayIndex = 0;
            this.endArrayIndex = this.length;
            this.matchers = new ByteMatcher[this.length];
            this.populateMatchers(matchers);
        }
    }

    public ByteMatcherSequenceMatcher(SequenceMatcher ... matchers) {
        ArgUtils.checkNullOrEmptyArrayNoNullElements(matchers);
        this.length = this.countTotalLength(matchers);
        this.startArrayIndex = 0;
        this.endArrayIndex = this.length;
        this.matchers = new ByteMatcher[this.length];
        this.populateMatchers(matchers);
    }

    public ByteMatcherSequenceMatcher(List<? extends SequenceMatcher> list) {
        ArgUtils.checkNullOrEmptyCollectionNoNullElements(list);
        this.length = this.countTotalLength(list);
        this.startArrayIndex = 0;
        this.endArrayIndex = this.length;
        this.matchers = new ByteMatcher[this.length];
        this.populateMatchers(list);
    }

    public ByteMatcherSequenceMatcher(ReverseByteMatcherSequenceMatcher matcher) {
        ArgUtils.checkNullObject(matcher);
        this.length = matcher.length;
        this.startArrayIndex = matcher.startArrayIndex;
        this.endArrayIndex = matcher.endArrayIndex;
        this.matchers = matcher.matchers;
    }

    @Override
    public boolean matches(WindowReader reader, long matchPosition) throws IOException {
        int localLength = this.length;
        int matchStart = this.startArrayIndex;
        int matchEnd = this.endArrayIndex;
        ByteMatcher[] matchList = this.matchers;
        Window window = reader.getWindow(matchPosition);
        int checkPos = matchStart;
        int bytesMatchedSoFar = 0;
        while (window != null) {
            int offset = reader.getWindowOffset(matchPosition + (long)bytesMatchedSoFar);
            int endPos = Math.min(window.length(), offset + localLength - bytesMatchedSoFar);
            byte[] array = window.getArray();
            for (int windowPos = offset; windowPos < endPos; ++windowPos) {
                ByteMatcher byteMatcher;
                if ((byteMatcher = matchList[checkPos++]).matches(array[windowPos])) continue;
                return false;
            }
            if (checkPos >= matchEnd) {
                return true;
            }
            bytesMatchedSoFar = checkPos - matchStart;
            window = reader.getWindow(matchPosition + (long)bytesMatchedSoFar);
        }
        return false;
    }

    @Override
    public boolean matches(byte[] bytes, int matchPosition) {
        if (matchPosition + this.length <= bytes.length && matchPosition >= 0) {
            int position = matchPosition;
            ByteMatcher[] localMatchers = this.matchers;
            int endIndex = this.endArrayIndex;
            for (int matcherPosition = this.startArrayIndex; matcherPosition < endIndex; ++matcherPosition) {
                if (localMatchers[matcherPosition].matches(bytes[position++])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesNoBoundsCheck(byte[] bytes, int matchPosition) {
        int position = matchPosition;
        ByteMatcher[] localMatchers = this.matchers;
        int endIndex = this.endArrayIndex;
        for (int matcherPosition = this.startArrayIndex; matcherPosition < endIndex; ++matcherPosition) {
            if (localMatchers[matcherPosition].matches(bytes[position++])) continue;
            return false;
        }
        return true;
    }

    @Override
    public ByteMatcher getMatcherForPosition(int position) {
        ArgUtils.checkIndexOutOfBounds(this.length, position);
        return this.matchers[this.startArrayIndex + position];
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public SequenceMatcher reverse() {
        return new ReverseByteMatcherSequenceMatcher(this);
    }

    @Override
    public String toRegularExpression(boolean prettyPrint) {
        StringBuilder builder = new StringBuilder(prettyPrint ? this.length * 4 : this.length * 3);
        boolean singleByte = false;
        boolean appended = false;
        ArrayList<Byte> singleBytes = new ArrayList<Byte>();
        for (int index = this.startArrayIndex; index < this.endArrayIndex; ++index) {
            ByteMatcher matcher = this.matchers[index];
            if (matcher.getNumberOfMatchingBytes() == 1) {
                singleByte = true;
                singleBytes.add(matcher.getMatchingBytes()[0]);
                continue;
            }
            if (singleByte) {
                builder.append(ByteUtils.bytesToString(prettyPrint, singleBytes));
                appended = true;
                singleBytes.clear();
                singleByte = false;
            }
            if (prettyPrint && appended) {
                builder.append(' ');
            }
            builder.append(matcher.toRegularExpression(prettyPrint));
            appended = true;
        }
        if (singleByte) {
            if (prettyPrint && appended) {
                builder.append(' ');
            }
            builder.append(ByteUtils.bytesToString(prettyPrint, singleBytes));
        }
        return builder.toString();
    }

    @Override
    public SequenceMatcher subsequence(int beginIndex, int endIndex) {
        ArgUtils.checkIndexOutOfBounds(this.length, beginIndex, endIndex);
        int subsequenceLength = endIndex - beginIndex;
        if (subsequenceLength == this.length) {
            return this;
        }
        if (subsequenceLength == 1) {
            return this.matchers[this.startArrayIndex + beginIndex];
        }
        return new ByteMatcherSequenceMatcher(this, beginIndex, endIndex);
    }

    @Override
    public SequenceMatcher subsequence(int beginIndex) {
        return this.subsequence(beginIndex, this.length);
    }

    @Override
    public SequenceMatcher repeat(int numberOfRepeats) {
        ArgUtils.checkPositiveInteger(numberOfRepeats);
        if (numberOfRepeats == 1) {
            return this;
        }
        return new ByteMatcherSequenceMatcher(this.repeatMatchers(numberOfRepeats));
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.toRegularExpression(true) + ']';
    }

    private void populateMatchers(int repeats, byte[] bytes, int startIndex, int endIndex) {
        int subsequenceLength = endIndex - startIndex;
        int totalLength = subsequenceLength * repeats;
        for (int position = 0; position < totalLength; ++position) {
            int arrayIndex = startIndex + position % subsequenceLength;
            this.matchers[position] = OneByteMatcher.valueOf(bytes[arrayIndex]);
        }
    }

    private void populateMatchers(int repeats, ByteMatcher[] byteMatchers, int startIndex, int endIndex) {
        int subsequenceLength = endIndex - startIndex;
        int totalLength = subsequenceLength * repeats;
        for (int position = 0; position < totalLength; ++position) {
            int arrayIndex = startIndex + position % subsequenceLength;
            this.matchers[position] = byteMatchers[arrayIndex];
        }
    }

    private void populateMatchers(int repeats, ByteMatcherSequenceMatcher source, int startIndex, int endIndex) {
        int subsequenceLength = endIndex - startIndex;
        int totalLength = subsequenceLength * repeats;
        int sourceStartIndex = source.startArrayIndex + startIndex;
        for (int position = 0; position < totalLength; ++position) {
            int sourceIndex = sourceStartIndex + position % subsequenceLength;
            this.matchers[position] = source.matchers[sourceIndex];
        }
    }

    private void populateMatchers(List<? extends SequenceMatcher> list) {
        int matcherPos = 0;
        for (SequenceMatcher sequenceMatcher : list) {
            for (ByteMatcher matcher : sequenceMatcher) {
                this.matchers[matcherPos++] = matcher;
            }
        }
    }

    private void populateMatchers(SequenceMatcher[] list) {
        int matcherPos = 0;
        for (SequenceMatcher sequence : list) {
            for (ByteMatcher matcher : sequence) {
                this.matchers[matcherPos++] = matcher;
            }
        }
    }

    private ByteMatcher[] repeatMatchers(int numberOfRepeats) {
        int repeatSize = this.matchers.length;
        ByteMatcher[] repeated = new ByteMatcher[repeatSize * numberOfRepeats];
        for (int repeat = 0; repeat < numberOfRepeats; ++repeat) {
            System.arraycopy(this.matchers, 0, repeated, repeat * repeatSize, repeatSize);
        }
        return repeated;
    }

    private int countTotalLength(List<? extends SequenceMatcher> list) {
        int totalLength = 0;
        for (SequenceMatcher sequenceMatcher : list) {
            totalLength += sequenceMatcher.length();
        }
        return totalLength;
    }

    private int countTotalLength(SequenceMatcher[] matchers) {
        int totalLength = 0;
        for (SequenceMatcher sequence : matchers) {
            totalLength += sequence.length();
        }
        return totalLength;
    }

    @Override
    public Iterator<ByteMatcher> iterator() {
        return new ByteMatcherSequenceIterator();
    }

    public static final class ReverseByteMatcherSequenceMatcher
    implements SequenceMatcher {
        private final ByteMatcher[] matchers;
        private final int startArrayIndex;
        private final int endArrayIndex;
        private final int length;

        public ReverseByteMatcherSequenceMatcher(byte[] array) {
            ArgUtils.checkNullOrEmptyByteArray(array);
            this.length = array.length;
            this.startArrayIndex = 0;
            this.endArrayIndex = this.length;
            this.matchers = new ByteMatcher[this.length];
            this.populateMatchers(array, 0, this.length);
        }

        public ReverseByteMatcherSequenceMatcher(ReverseByteMatcherSequenceMatcher original, int startIndex, int endIndex) {
            ArgUtils.checkNullObject(original);
            ArgUtils.checkIndexOutOfBounds(original.length(), startIndex, endIndex);
            this.length = endIndex - startIndex;
            this.startArrayIndex = original.startArrayIndex + original.length - endIndex;
            this.endArrayIndex = original.endArrayIndex - startIndex;
            this.matchers = original.matchers;
        }

        public ReverseByteMatcherSequenceMatcher(int numberOfRepeats, ReverseByteMatcherSequenceMatcher original) {
            this(numberOfRepeats, original, 0, original.length);
        }

        public ReverseByteMatcherSequenceMatcher(int numberOfRepeats, ReverseByteMatcherSequenceMatcher original, int startIndex, int endIndex) {
            ArgUtils.checkPositiveInteger(numberOfRepeats);
            ArgUtils.checkNullObject(original);
            ArgUtils.checkIndexOutOfBounds(original.length(), startIndex, endIndex);
            this.length = (endIndex - startIndex) * numberOfRepeats;
            if (numberOfRepeats == 1) {
                this.matchers = original.matchers;
                this.startArrayIndex = original.startArrayIndex + startIndex;
                this.endArrayIndex = original.startArrayIndex + endIndex;
            } else {
                this.matchers = this.repeatReverseMatchers(numberOfRepeats, original.matchers, startIndex, endIndex);
                this.startArrayIndex = 0;
                this.endArrayIndex = this.length;
            }
        }

        public ReverseByteMatcherSequenceMatcher(ByteMatcherSequenceMatcher forwardMatcher) {
            ArgUtils.checkNullObject(forwardMatcher);
            this.length = forwardMatcher.length;
            this.matchers = forwardMatcher.matchers;
            this.startArrayIndex = forwardMatcher.startArrayIndex;
            this.endArrayIndex = forwardMatcher.endArrayIndex;
        }

        public ReverseByteMatcherSequenceMatcher(int repeats, byte[] array, int startIndex, int endIndex) {
            ArgUtils.checkNullOrEmptyByteArray(array);
            ArgUtils.checkIndexOutOfBounds(array.length, startIndex, endIndex);
            ArgUtils.checkPositiveInteger(repeats, "numberOfRepeats");
            byte[] repeated = ByteUtils.repeat(repeats, array, startIndex, endIndex);
            this.length = repeated.length;
            this.startArrayIndex = 0;
            this.endArrayIndex = this.length;
            this.matchers = new ByteMatcher[this.length];
            this.populateMatchers(repeated, 0, this.length);
        }

        public ReverseByteMatcherSequenceMatcher(byte byteValue) {
            this.matchers = new ByteMatcher[]{OneByteMatcher.valueOf(byteValue)};
            this.length = 1;
            this.startArrayIndex = 0;
            this.endArrayIndex = 1;
        }

        @Override
        public boolean matches(WindowReader reader, long matchPosition) throws IOException {
            int matchStart = this.startArrayIndex;
            int matchLength = this.endArrayIndex - this.startArrayIndex;
            int matchEnd = this.endArrayIndex - 1;
            ByteMatcher[] matchArray = this.matchers;
            Window window = reader.getWindow(matchPosition);
            int matchPos = matchEnd;
            int bytesMatchedSoFar = 0;
            while (window != null) {
                int finalMatchIndex;
                byte[] source = window.getArray();
                int offset = reader.getWindowOffset(matchPosition + (long)bytesMatchedSoFar);
                int finalWindowIndex = window.length();
                int sourceEnd = finalWindowIndex < (finalMatchIndex = offset + matchLength - bytesMatchedSoFar) ? finalWindowIndex : finalMatchIndex;
                for (int sourcePos = offset; sourcePos < sourceEnd; ++sourcePos) {
                    if (matchArray[matchPos--].matches(source[sourcePos])) continue;
                    return false;
                }
                if (matchPos < matchStart) {
                    return true;
                }
                bytesMatchedSoFar = matchEnd - matchPos;
                window = reader.getWindow(matchPosition + (long)bytesMatchedSoFar);
            }
            return false;
        }

        @Override
        public boolean matches(byte[] bytes, int matchPosition) {
            if (matchPosition + this.length() <= bytes.length && matchPosition >= 0) {
                ByteMatcher[] matchArray = this.matchers;
                int endingIndex = this.startArrayIndex;
                int position = matchPosition;
                for (int matchIndex = this.endArrayIndex - 1; matchIndex >= endingIndex; --matchIndex) {
                    if (matchArray[matchIndex].matches(bytes[position++])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean matchesNoBoundsCheck(byte[] bytes, int matchPosition) {
            int position = matchPosition;
            ByteMatcher[] matchArray = this.matchers;
            int endingIndex = this.startArrayIndex;
            for (int matchIndex = this.endArrayIndex - 1; matchIndex >= endingIndex; --matchIndex) {
                if (matchArray[matchIndex].matches(bytes[position++])) continue;
                return false;
            }
            return true;
        }

        @Override
        public ByteMatcher getMatcherForPosition(int position) {
            ArgUtils.checkIndexOutOfBounds(this.length, position);
            return this.matchers[this.endArrayIndex - position - 1];
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public SequenceMatcher reverse() {
            return new ByteMatcherSequenceMatcher(this);
        }

        @Override
        public SequenceMatcher subsequence(int beginIndex, int endIndex) {
            ArgUtils.checkIndexOutOfBounds(this.length(), beginIndex, endIndex);
            int subsequenceLength = endIndex - beginIndex;
            if (subsequenceLength == this.length) {
                return this;
            }
            if (subsequenceLength == 1) {
                return this.matchers[this.endArrayIndex - beginIndex - 1];
            }
            return new ReverseByteMatcherSequenceMatcher(this, beginIndex, endIndex);
        }

        @Override
        public SequenceMatcher subsequence(int beginIndex) {
            return this.subsequence(beginIndex, this.length);
        }

        @Override
        public SequenceMatcher repeat(int numberOfRepeats) {
            ArgUtils.checkPositiveInteger(numberOfRepeats);
            if (numberOfRepeats == 1) {
                return this;
            }
            return new ReverseByteMatcherSequenceMatcher(numberOfRepeats, this);
        }

        @Override
        public String toRegularExpression(boolean prettyPrint) {
            StringBuilder builder = new StringBuilder(prettyPrint ? this.length * 4 : this.length * 3);
            boolean singleByte = false;
            boolean appended = false;
            ArrayList<Byte> singleBytes = new ArrayList<Byte>();
            for (int index = this.endArrayIndex - 1; index >= this.startArrayIndex; --index) {
                ByteMatcher matcher = this.matchers[index];
                if (matcher.getNumberOfMatchingBytes() == 1) {
                    singleByte = true;
                    singleBytes.add(matcher.getMatchingBytes()[0]);
                    continue;
                }
                if (singleByte) {
                    builder.append(ByteUtils.bytesToString(prettyPrint, singleBytes));
                    appended = true;
                    singleBytes.clear();
                    singleByte = false;
                }
                if (prettyPrint && appended) {
                    builder.append(' ');
                }
                builder.append(matcher.toRegularExpression(prettyPrint));
                appended = true;
            }
            if (singleByte) {
                if (prettyPrint && appended) {
                    builder.append(' ');
                }
                builder.append(ByteUtils.bytesToString(prettyPrint, singleBytes));
            }
            return builder.toString();
        }

        public String toString() {
            return "ReverseByteMatcherSequenceMatcher." + this.getClass().getSimpleName() + '[' + this.toRegularExpression(true) + ']';
        }

        @Override
        public Iterator<ByteMatcher> iterator() {
            return new ReverseByteMatcherSequenceMatcherIterator();
        }

        private void populateMatchers(byte[] bytes, int startIndex, int endIndex) {
            int matcherPosition = 0;
            for (int position = startIndex; position < endIndex; ++position) {
                this.matchers[matcherPosition++] = OneByteMatcher.valueOf(bytes[position]);
            }
        }

        private ByteMatcher[] repeatReverseMatchers(int numberOfRepeats, ByteMatcher[] matchersToRepeat, int startIndex, int endIndex) {
            int repeatSize = endIndex - startIndex;
            ByteMatcher[] repeated = new ByteMatcher[repeatSize * numberOfRepeats];
            for (int repeat = 0; repeat < numberOfRepeats; ++repeat) {
                System.arraycopy(matchersToRepeat, startIndex, repeated, repeat * repeatSize, repeatSize);
            }
            return repeated;
        }

        private class ReverseByteMatcherSequenceMatcherIterator
        implements Iterator<ByteMatcher> {
            int position;

            private ReverseByteMatcherSequenceMatcherIterator() {
                this.position = ReverseByteMatcherSequenceMatcher.this.endArrayIndex;
            }

            @Override
            public boolean hasNext() {
                return this.position > ReverseByteMatcherSequenceMatcher.this.startArrayIndex;
            }

            @Override
            public ByteMatcher next() {
                if (this.hasNext()) {
                    return ReverseByteMatcherSequenceMatcher.this.matchers[--this.position];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove byte matchers from a ReverseByteMatcherSequenceMatcher");
            }
        }
    }

    private class ByteMatcherSequenceIterator
    implements Iterator<ByteMatcher> {
        int position;

        private ByteMatcherSequenceIterator() {
            this.position = ByteMatcherSequenceMatcher.this.startArrayIndex;
        }

        @Override
        public boolean hasNext() {
            return this.position < ByteMatcherSequenceMatcher.this.endArrayIndex;
        }

        @Override
        public ByteMatcher next() {
            if (this.hasNext()) {
                return ByteMatcherSequenceMatcher.this.matchers[this.position++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove matchers from a ByteMatcherSequenceMatcher");
        }
    }
}

