/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.parser.tree.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.byteseek.parser.tree.ParseTree;
import net.byteseek.parser.tree.ParseTreeType;
import net.byteseek.parser.tree.node.BaseNode;
import net.byteseek.utils.collections.ImmutableListIterator;

public final class ChildrenNode
extends BaseNode {
    private final List<ParseTree> children;
    private final boolean inverted;

    public ChildrenNode(ParseTreeType type) {
        this(type, (List<ParseTree>)null, false);
    }

    public ChildrenNode(ParseTreeType type, boolean isInverted) {
        this(type, (List<ParseTree>)null, isInverted);
    }

    public ChildrenNode(ParseTreeType type, List<ParseTree> children) {
        this(type, children, false);
    }

    public ChildrenNode(ParseTreeType type, ParseTree child) {
        this(type, child, false);
    }

    public ChildrenNode(ParseTreeType type, ParseTree child, boolean inverted) {
        super(type);
        if (child == null) {
            this.children = new ArrayList<ParseTree>(0);
        } else {
            this.children = new ArrayList<ParseTree>(1);
            this.children.add(child);
        }
        this.inverted = inverted;
    }

    public ChildrenNode(ParseTreeType type, ParseTree ... parseTrees) {
        this(type, false, parseTrees);
    }

    public ChildrenNode(ParseTreeType type, boolean inverted, ParseTree ... parseTrees) {
        super(type);
        this.children = Arrays.asList(parseTrees);
        this.inverted = inverted;
    }

    public ChildrenNode(ParseTreeType type, List<ParseTree> children, boolean inverted) {
        super(type);
        this.children = children == null ? new ArrayList<ParseTree>(0) : new ArrayList<ParseTree>(children);
        this.inverted = inverted;
    }

    @Override
    public int getNumChildren() {
        return this.children.size();
    }

    @Override
    public ParseTree getChild(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public Iterator<ParseTree> iterator() {
        return new ImmutableListIterator<ParseTree>(this.children);
    }

    @Override
    public boolean isValueInverted() {
        return this.inverted;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + '[' + (Object)((Object)this.getParseTreeType()) + ", num children:" + this.children.size() + ']';
    }
}

