/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.searcher;

import java.io.IOException;
import java.util.List;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.searcher.SearchResult;
import net.byteseek.searcher.Searcher;

public abstract class AbstractSearcher<T>
implements Searcher<T> {
    @Override
    public List<SearchResult<T>> searchForwards(WindowReader reader, long fromPosition) throws IOException {
        return this.searchForwards(reader, fromPosition, Long.MAX_VALUE);
    }

    @Override
    public List<SearchResult<T>> searchForwards(WindowReader reader) throws IOException {
        return this.searchForwards(reader, 0L, Long.MAX_VALUE);
    }

    @Override
    public List<SearchResult<T>> searchForwards(byte[] bytes, int fromPosition) {
        return this.searchForwards(bytes, fromPosition, bytes.length - 1);
    }

    @Override
    public List<SearchResult<T>> searchForwards(byte[] bytes) {
        return this.searchForwards(bytes, 0, bytes.length - 1);
    }

    @Override
    public List<SearchResult<T>> searchBackwards(WindowReader reader, long fromPosition) throws IOException {
        return this.searchBackwards(reader, fromPosition, 0L);
    }

    @Override
    public List<SearchResult<T>> searchBackwards(WindowReader reader) throws IOException {
        return this.searchBackwards(reader, reader.length() - 1L, 0L);
    }

    @Override
    public List<SearchResult<T>> searchBackwards(byte[] bytes, int fromPosition) {
        return this.searchBackwards(bytes, fromPosition, 0);
    }

    @Override
    public List<SearchResult<T>> searchBackwards(byte[] bytes) {
        return this.searchBackwards(bytes, bytes.length - 1, 0);
    }

    protected final long withinLength(WindowReader reader, long position) throws IOException {
        long positionToTry = position > 0L ? position : 0L;
        return reader.getWindow(positionToTry) != null ? positionToTry : reader.length() - 1L;
    }
}

