/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.searcher.bytes;

import java.io.IOException;
import java.util.List;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.bytes.OneByteMatcher;
import net.byteseek.searcher.AbstractSearcher;
import net.byteseek.searcher.SearchResult;
import net.byteseek.searcher.SearchUtils;
import net.byteseek.utils.ArgUtils;

public final class ByteSearcher
extends AbstractSearcher<Byte> {
    private final byte toSearchFor;
    private final Byte byteValue;

    public ByteSearcher(byte value) {
        this.toSearchFor = value;
        this.byteValue = value;
    }

    public ByteSearcher(Byte value) {
        ArgUtils.checkNullObject(value, "Byte passed in cannot be null.");
        this.toSearchFor = value;
        this.byteValue = value;
    }

    public ByteSearcher(OneByteMatcher value) {
        ArgUtils.checkNullObject(value, "OneByteMatcher passed in cannot be null.");
        this.toSearchFor = value.getMatchingBytes()[0];
        this.byteValue = this.toSearchFor;
    }

    @Override
    public List<SearchResult<Byte>> searchForwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
        Window window;
        long searchPosition;
        byte searchByte = this.toSearchFor;
        Byte resultValue = this.byteValue;
        long l = searchPosition = fromPosition >= 0L ? fromPosition : 0L;
        while (searchPosition <= toPosition && (window = reader.getWindow(searchPosition)) != null) {
            long distanceToSearchEnd;
            byte[] array = window.getArray();
            int startWindowSearchPosition = reader.getWindowOffset(searchPosition);
            int distanceToWindowEnd = window.length() - 1 - startWindowSearchPosition;
            int endWindowSearchPosition = (long)distanceToWindowEnd < (distanceToSearchEnd = toPosition - searchPosition) ? startWindowSearchPosition + distanceToWindowEnd : startWindowSearchPosition + (int)distanceToSearchEnd;
            for (int arraySearchPosition = startWindowSearchPosition; arraySearchPosition <= endWindowSearchPosition; ++arraySearchPosition) {
                if (array[arraySearchPosition] != searchByte) continue;
                long matchPosition = searchPosition + (long)arraySearchPosition - (long)startWindowSearchPosition;
                return SearchUtils.singleResult(matchPosition, resultValue);
            }
            searchPosition += (long)(distanceToWindowEnd + 1);
        }
        return SearchUtils.noResults();
    }

    @Override
    public List<SearchResult<Byte>> searchForwards(byte[] bytes, int fromPosition, int toPosition) {
        int searchPosition;
        byte searchByte = this.toSearchFor;
        Byte resultValue = this.byteValue;
        int lastPosition = toPosition < bytes.length ? toPosition : bytes.length - 1;
        int n = searchPosition = fromPosition > 0 ? fromPosition : 0;
        while (searchPosition <= lastPosition) {
            if (searchByte == bytes[searchPosition]) {
                return SearchUtils.singleResult(searchPosition, resultValue);
            }
            ++searchPosition;
        }
        return SearchUtils.noResults();
    }

    @Override
    public List<SearchResult<Byte>> searchBackwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
        Window window;
        int startWindowSearchPosition;
        byte searchByte = this.toSearchFor;
        Byte resultValue = this.byteValue;
        for (long searchPosition = fromPosition; searchPosition >= toPosition && (window = reader.getWindow(searchPosition)) != null; searchPosition -= (long)(startWindowSearchPosition + 1)) {
            byte[] array = window.getArray();
            long distanceToSearchEnd = searchPosition - toPosition;
            startWindowSearchPosition = reader.getWindowOffset(searchPosition);
            int endWindowSearchPosition = distanceToSearchEnd > (long)startWindowSearchPosition ? 0 : startWindowSearchPosition - (int)distanceToSearchEnd;
            for (int arraySearchPosition = startWindowSearchPosition; arraySearchPosition >= endWindowSearchPosition; --arraySearchPosition) {
                if (array[arraySearchPosition] != searchByte) continue;
                long matchPosition = searchPosition - (long)(startWindowSearchPosition - arraySearchPosition);
                return SearchUtils.singleResult(matchPosition, resultValue);
            }
        }
        return SearchUtils.noResults();
    }

    @Override
    public List<SearchResult<Byte>> searchBackwards(byte[] bytes, int fromPosition, int toPosition) {
        int searchPosition;
        byte searchByte = this.toSearchFor;
        Byte resultValue = this.byteValue;
        int lastPosition = toPosition > 0 ? toPosition : 0;
        int n = searchPosition = fromPosition < bytes.length ? fromPosition : bytes.length - 1;
        while (searchPosition >= lastPosition) {
            if (searchByte == bytes[searchPosition]) {
                return SearchUtils.singleResult(searchPosition, resultValue);
            }
            --searchPosition;
        }
        return SearchUtils.noResults();
    }

    @Override
    public void prepareForwards() {
    }

    @Override
    public void prepareBackwards() {
    }

    public String toString() {
        int value = this.toSearchFor & 0xFF;
        return this.getClass().getSimpleName() + '[' + String.format("%02X", value) + ']';
    }
}

