/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.searcher.multisequence;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.multisequence.MultiSequenceMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.searcher.SearchResult;
import net.byteseek.searcher.SearchUtils;
import net.byteseek.searcher.multisequence.AbstractMultiSequenceSearcher;

public class MultiSequenceMatcherSearcher
extends AbstractMultiSequenceSearcher {
    public MultiSequenceMatcherSearcher(MultiSequenceMatcher matcher) {
        super(matcher);
    }

    @Override
    protected List<SearchResult<SequenceMatcher>> doSearchForwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
        Window window;
        long searchPosition;
        MultiSequenceMatcher matcher = this.sequences;
        long l = searchPosition = fromPosition > 0L ? fromPosition : 0L;
        while (searchPosition <= toPosition && (window = reader.getWindow(searchPosition)) != null) {
            long lastPosition;
            int availableSpace = window.length() - reader.getWindowOffset(searchPosition);
            long endWindowPosition = searchPosition + (long)availableSpace;
            long l2 = lastPosition = endWindowPosition < toPosition ? endWindowPosition : toPosition;
            while (searchPosition <= lastPosition) {
                Collection<SequenceMatcher> matches = matcher.allMatches(reader, searchPosition);
                if (!matches.isEmpty()) {
                    return SearchUtils.resultsAtPosition(searchPosition, matches);
                }
                ++searchPosition;
            }
        }
        return SearchUtils.noResults();
    }

    @Override
    public List<SearchResult<SequenceMatcher>> searchForwards(byte[] bytes, int fromPosition, int toPosition) {
        int searchPosition;
        MultiSequenceMatcher matcher = this.sequences;
        int lastPossiblePosition = bytes.length - this.sequences.getMinimumLength();
        int lastPosition = toPosition < lastPossiblePosition ? toPosition : lastPossiblePosition;
        int n = searchPosition = fromPosition > 0 ? fromPosition : 0;
        while (searchPosition <= lastPosition) {
            Collection<SequenceMatcher> matches = matcher.allMatches(bytes, searchPosition);
            if (!matches.isEmpty()) {
                return SearchUtils.resultsAtPosition(searchPosition, matches);
            }
            ++searchPosition;
        }
        return SearchUtils.noResults();
    }

    @Override
    protected List<SearchResult<SequenceMatcher>> doSearchBackwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
        Window window;
        MultiSequenceMatcher matcher = this.sequences;
        long searchPosition = this.withinLength(reader, fromPosition);
        while (searchPosition >= toPosition && (window = reader.getWindow(searchPosition)) != null) {
            long lastSearchPosition;
            long windowStartPosition = window.getWindowPosition();
            long l = lastSearchPosition = toPosition > windowStartPosition ? toPosition : windowStartPosition;
            while (searchPosition >= lastSearchPosition) {
                Collection<SequenceMatcher> matches = matcher.allMatches(reader, searchPosition);
                if (!matches.isEmpty()) {
                    return SearchUtils.resultsAtPosition(searchPosition, matches);
                }
                --searchPosition;
            }
        }
        return SearchUtils.noResults();
    }

    @Override
    public List<SearchResult<SequenceMatcher>> searchBackwards(byte[] bytes, int fromPosition, int toPosition) {
        int searchPosition;
        MultiSequenceMatcher matcher = this.sequences;
        int lastPosition = toPosition > 0 ? toPosition : 0;
        int firstPossiblePosition = bytes.length - this.sequences.getMinimumLength();
        int n = searchPosition = fromPosition < firstPossiblePosition ? fromPosition : firstPossiblePosition;
        while (searchPosition >= lastPosition) {
            Collection<SequenceMatcher> matches = matcher.allMatches(bytes, searchPosition);
            if (!matches.isEmpty()) {
                return SearchUtils.resultsAtPosition(searchPosition, matches);
            }
            --searchPosition;
        }
        return SearchUtils.noResults();
    }

    @Override
    public void prepareForwards() {
    }

    @Override
    public void prepareBackwards() {
    }
}

