/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.searcher.multisequence.wu_manber;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.byteseek.matcher.bytes.ByteMatcher;
import net.byteseek.matcher.multisequence.MultiSequenceMatcher;
import net.byteseek.matcher.multisequence.MultiSequenceReverseMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.searcher.multisequence.AbstractMultiSequenceSearcher;
import net.byteseek.utils.ByteUtils;
import net.byteseek.utils.collections.BytePermutationIterator;
import net.byteseek.utils.factory.ObjectFactory;
import net.byteseek.utils.lazy.DoubleCheckImmutableLazyObject;
import net.byteseek.utils.lazy.LazyObject;

public abstract class AbstractWuManberSearcher
extends AbstractMultiSequenceSearcher {
    private static final int HIGHEST_POWER_OF_TWO = 0x40000000;
    protected final int blockSize;
    protected final LazyObject<SearchInfo> forwardInfo;
    protected final LazyObject<SearchInfo> backwardInfo;

    public AbstractWuManberSearcher(MultiSequenceMatcher matcher, int blockSize) {
        super(matcher);
        this.blockSize = blockSize;
        this.forwardInfo = new DoubleCheckImmutableLazyObject<SearchInfo>(new ForwardInfoFactory());
        this.backwardInfo = new DoubleCheckImmutableLazyObject<SearchInfo>(new BackwardSearchInfo());
    }

    @Override
    public void prepareForwards() {
        this.forwardInfo.get();
    }

    @Override
    public void prepareBackwards() {
        this.backwardInfo.get();
    }

    private List<byte[]> getBlockByteList(int position, SequenceMatcher matcher) {
        ArrayList<byte[]> byteList = new ArrayList<byte[]>(this.blockSize);
        for (int blockIndex = position - this.blockSize + 1; blockIndex <= position; ++blockIndex) {
            ByteMatcher byteMatcher = matcher.getMatcherForPosition(blockIndex);
            byteList.add(byteMatcher.getMatchingBytes());
        }
        return byteList;
    }

    private static int getBlockHash(byte[] block) {
        int hashCode = 0;
        for (byte b : block) {
            hashCode = (hashCode << 5) - hashCode + (b & 0xFF);
        }
        return hashCode;
    }

    private int[] createShiftHashTable(int defaultShift) {
        int possibleTableSize = this.guessTableSize();
        int optimumTableSize = this.chooseOptimumSize(possibleTableSize);
        int[] shifts = new int[optimumTableSize];
        Arrays.fill(shifts, defaultShift);
        return shifts;
    }

    private int guessTableSize() {
        return 128 + this.sequences.getSequenceMatchers().size() * 16;
    }

    private int chooseOptimumSize(int suggestedSize) {
        int positiveSize = suggestedSize > 1 ? suggestedSize : 1;
        int possibleSize = ByteUtils.isPowerOfTwo(positiveSize) ? positiveSize : ByteUtils.nextHighestPowerOfTwo(positiveSize);
        int maxSize = this.getMaxTableSize();
        return possibleSize < maxSize ? possibleSize : maxSize;
    }

    private int getMaxTableSize() {
        switch (this.blockSize) {
            case 1: {
                return 256;
            }
            case 2: {
                return 65536;
            }
            case 3: {
                return 0x1000000;
            }
        }
        return 0x40000000;
    }

    protected class BackwardSearchInfo
    implements ObjectFactory<SearchInfo> {
        protected BackwardSearchInfo() {
        }

        @Override
        public SearchInfo create() {
            return new SearchInfo(this.getShifts(), this.getMatcher());
        }

        private int[] getShifts() {
            int minLength = AbstractWuManberSearcher.this.sequences.getMinimumLength();
            int defaultShift = minLength - AbstractWuManberSearcher.this.blockSize + 1;
            int[] shifts = AbstractWuManberSearcher.this.createShiftHashTable(defaultShift);
            int hashBitMask = shifts.length - 1;
            for (SequenceMatcher sequence : AbstractWuManberSearcher.this.sequences.getSequenceMatchers()) {
                for (int blockEndPosition = AbstractWuManberSearcher.this.blockSize - 1; blockEndPosition < minLength; ++blockEndPosition) {
                    int distanceToStart = blockEndPosition - AbstractWuManberSearcher.this.blockSize + 1;
                    List blockBytes = AbstractWuManberSearcher.this.getBlockByteList(blockEndPosition, sequence);
                    BytePermutationIterator permutation = new BytePermutationIterator(blockBytes);
                    while (permutation.hasNext()) {
                        int hashPos = AbstractWuManberSearcher.getBlockHash(permutation.next()) & hashBitMask;
                        int currentShift = shifts[hashPos];
                        if (distanceToStart >= currentShift) continue;
                        shifts[hashPos] = distanceToStart;
                    }
                }
            }
            return shifts;
        }

        private MultiSequenceMatcher getMatcher() {
            return AbstractWuManberSearcher.this.sequences;
        }
    }

    protected class ForwardInfoFactory
    implements ObjectFactory<SearchInfo> {
        protected ForwardInfoFactory() {
        }

        @Override
        public SearchInfo create() {
            return new SearchInfo(this.getShifts(), this.getMatcher());
        }

        private int[] getShifts() {
            int defaultShift = AbstractWuManberSearcher.this.sequences.getMinimumLength() - AbstractWuManberSearcher.this.blockSize + 1;
            int[] shifts = AbstractWuManberSearcher.this.createShiftHashTable(defaultShift);
            int hashBitMask = shifts.length - 1;
            for (SequenceMatcher sequence : AbstractWuManberSearcher.this.sequences.getSequenceMatchers()) {
                int firstBlockEndPosition;
                int matcherLength = sequence.length();
                for (int blockEndPosition = firstBlockEndPosition = matcherLength - AbstractWuManberSearcher.this.sequences.getMinimumLength() + AbstractWuManberSearcher.this.blockSize - 1; blockEndPosition < matcherLength; ++blockEndPosition) {
                    int distanceFromEnd = matcherLength - blockEndPosition - 1;
                    List blockBytes = AbstractWuManberSearcher.this.getBlockByteList(blockEndPosition, sequence);
                    BytePermutationIterator permutation = new BytePermutationIterator(blockBytes);
                    while (permutation.hasNext()) {
                        int hashPos = AbstractWuManberSearcher.getBlockHash(permutation.next()) & hashBitMask;
                        int currentShift = shifts[hashPos];
                        if (distanceFromEnd >= currentShift) continue;
                        shifts[hashPos] = distanceFromEnd;
                    }
                }
            }
            return shifts;
        }

        private MultiSequenceMatcher getMatcher() {
            return new MultiSequenceReverseMatcher(AbstractWuManberSearcher.this.sequences);
        }
    }

    protected static final class SearchInfo {
        public final int[] shifts;
        public final MultiSequenceMatcher matcher;

        public SearchInfo(int[] shifts, MultiSequenceMatcher matcher) {
            this.shifts = shifts;
            this.matcher = matcher;
        }
    }
}

