/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.searcher.multisequence.wu_manber;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.byteseek.matcher.bytes.ByteMatcher;
import net.byteseek.matcher.multisequence.MultiSequenceMatcher;
import net.byteseek.matcher.multisequence.MultiSequenceReverseMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.searcher.multisequence.AbstractMultiSequenceSearcher;
import net.byteseek.utils.ByteUtils;
import net.byteseek.utils.collections.BytePermutationIterator;
import net.byteseek.utils.factory.ObjectFactory;
import net.byteseek.utils.lazy.DoubleCheckImmutableLazyObject;
import net.byteseek.utils.lazy.LazyObject;

public abstract class AbstractWuManberTunedSearcher
extends AbstractMultiSequenceSearcher {
    private static final int HIGHEST_POWER_OF_TWO = 0x40000000;
    protected final int blockSize;
    protected final LazyObject<SearchInfo> forwardInfo;
    protected final LazyObject<SearchInfo> backwardInfo;

    public AbstractWuManberTunedSearcher(MultiSequenceMatcher matcher, int blockSize) {
        super(matcher);
        this.blockSize = blockSize;
        this.forwardInfo = new DoubleCheckImmutableLazyObject<SearchInfo>(new ForwardInfoFactory());
        this.backwardInfo = new DoubleCheckImmutableLazyObject<SearchInfo>(new BackwardInfoFactory());
    }

    @Override
    public void prepareForwards() {
        this.forwardInfo.get();
    }

    @Override
    public void prepareBackwards() {
        this.backwardInfo.get();
    }

    private List<byte[]> getBlockByteList(int position, SequenceMatcher matcher) {
        ArrayList<byte[]> byteList = new ArrayList<byte[]>(this.blockSize);
        for (int blockIndex = position - this.blockSize + 1; blockIndex <= position; ++blockIndex) {
            ByteMatcher byteMatcher = matcher.getMatcherForPosition(blockIndex);
            byteList.add(byteMatcher.getMatchingBytes());
        }
        return byteList;
    }

    private static int getBlockHash(byte[] block) {
        int hashCode = 0;
        for (byte b : block) {
            hashCode = (hashCode << 5) - hashCode + (b & 0xFF);
        }
        return hashCode;
    }

    private int[] createShiftHashTable(int defaultShift) {
        int possibleTableSize = this.guessTableSize();
        int optimumTableSize = this.chooseOptimumSize(possibleTableSize);
        int[] shifts = new int[optimumTableSize];
        Arrays.fill(shifts, defaultShift);
        return shifts;
    }

    private int[] createFinalShiftHashTable(int defaultShift) {
        int[] finalShifts = new int[32];
        Arrays.fill(finalShifts, defaultShift);
        return finalShifts;
    }

    private int guessTableSize() {
        return 128 + this.sequences.getSequenceMatchers().size() * 16;
    }

    private int chooseOptimumSize(int suggestedSize) {
        int positiveSize = suggestedSize > 1 ? suggestedSize : 1;
        int possibleSize = ByteUtils.isPowerOfTwo(positiveSize) ? positiveSize : ByteUtils.nextHighestPowerOfTwo(positiveSize);
        int maxSize = this.getMaxTableSize();
        return possibleSize < maxSize ? possibleSize : maxSize;
    }

    private int getMaxTableSize() {
        switch (this.blockSize) {
            case 1: {
                return 256;
            }
            case 2: {
                return 65536;
            }
            case 3: {
                return 0x1000000;
            }
        }
        return 0x40000000;
    }

    protected class BackwardInfoFactory
    implements ObjectFactory<SearchInfo> {
        protected BackwardInfoFactory() {
        }

        @Override
        public SearchInfo create() {
            int minLength = AbstractWuManberTunedSearcher.this.sequences.getMinimumLength();
            int defaultShift = minLength - AbstractWuManberTunedSearcher.this.blockSize + 1;
            int[] shifts = AbstractWuManberTunedSearcher.this.createShiftHashTable(defaultShift);
            int[] finalShifts = AbstractWuManberTunedSearcher.this.createFinalShiftHashTable(defaultShift);
            int hashBitMask = shifts.length - 1;
            int finalHashBitMask = finalShifts.length - 1;
            for (SequenceMatcher sequence : AbstractWuManberTunedSearcher.this.sequences.getSequenceMatchers()) {
                for (int blockEndPosition = AbstractWuManberTunedSearcher.this.blockSize - 1; blockEndPosition < minLength; ++blockEndPosition) {
                    int distanceToStart = blockEndPosition - AbstractWuManberTunedSearcher.this.blockSize + 1;
                    List blockBytes = AbstractWuManberTunedSearcher.this.getBlockByteList(blockEndPosition, sequence);
                    BytePermutationIterator permutation = new BytePermutationIterator(blockBytes);
                    while (permutation.hasNext()) {
                        int finalShift;
                        int hashPos = AbstractWuManberTunedSearcher.getBlockHash(permutation.next()) & hashBitMask;
                        int currentShift = shifts[hashPos];
                        if (distanceToStart == 0 && currentShift < (finalShift = finalShifts[hashPos & finalHashBitMask])) {
                            finalShifts[hashPos & finalHashBitMask] = currentShift;
                        }
                        if (distanceToStart >= currentShift) continue;
                        shifts[hashPos] = distanceToStart;
                    }
                }
            }
            return new SearchInfo(shifts, finalShifts, AbstractWuManberTunedSearcher.this.sequences);
        }
    }

    protected class ForwardInfoFactory
    implements ObjectFactory<SearchInfo> {
        protected ForwardInfoFactory() {
        }

        @Override
        public SearchInfo create() {
            int hashValue;
            int lastMatcherPosition;
            int matcherLength;
            int defaultShift = AbstractWuManberTunedSearcher.this.sequences.getMinimumLength() - AbstractWuManberTunedSearcher.this.blockSize + 1;
            int[] shifts = AbstractWuManberTunedSearcher.this.createShiftHashTable(defaultShift);
            int[] finalShifts = AbstractWuManberTunedSearcher.this.createFinalShiftHashTable(defaultShift);
            int hashBitMask = shifts.length - 1;
            int finalHashBitMask = finalShifts.length - 1;
            for (SequenceMatcher sequence : AbstractWuManberTunedSearcher.this.sequences.getSequenceMatchers()) {
                int firstBlockEndPosition;
                matcherLength = sequence.length();
                lastMatcherPosition = matcherLength - 1;
                for (int blockEndPosition = firstBlockEndPosition = matcherLength - AbstractWuManberTunedSearcher.this.sequences.getMinimumLength() + AbstractWuManberTunedSearcher.this.blockSize - 1; blockEndPosition < lastMatcherPosition; ++blockEndPosition) {
                    int distanceFromEnd = matcherLength - blockEndPosition - 1;
                    List blockBytes = AbstractWuManberTunedSearcher.this.getBlockByteList(blockEndPosition, sequence);
                    BytePermutationIterator permutation = new BytePermutationIterator(blockBytes);
                    while (permutation.hasNext()) {
                        int hashPos = AbstractWuManberTunedSearcher.getBlockHash(permutation.next()) & hashBitMask;
                        int currentShift = shifts[hashPos];
                        if (distanceFromEnd >= currentShift) continue;
                        shifts[hashPos] = distanceFromEnd;
                    }
                }
            }
            for (SequenceMatcher sequence : AbstractWuManberTunedSearcher.this.sequences.getSequenceMatchers()) {
                matcherLength = sequence.length();
                lastMatcherPosition = matcherLength - 1;
                List blockBytes = AbstractWuManberTunedSearcher.this.getBlockByteList(lastMatcherPosition, sequence);
                BytePermutationIterator permutation = new BytePermutationIterator(blockBytes);
                while (permutation.hasNext()) {
                    int finalShift;
                    hashValue = AbstractWuManberTunedSearcher.getBlockHash(permutation.next());
                    int currentShift = shifts[hashValue & hashBitMask];
                    if (currentShift <= 0 || currentShift >= (finalShift = finalShifts[hashValue & finalHashBitMask])) continue;
                    finalShifts[hashValue & finalHashBitMask] = currentShift;
                }
            }
            for (SequenceMatcher sequence : AbstractWuManberTunedSearcher.this.sequences.getSequenceMatchers()) {
                matcherLength = sequence.length();
                lastMatcherPosition = matcherLength - 1;
                List blockBytes = AbstractWuManberTunedSearcher.this.getBlockByteList(lastMatcherPosition, sequence);
                BytePermutationIterator permutation = new BytePermutationIterator(blockBytes);
                while (permutation.hasNext()) {
                    hashValue = AbstractWuManberTunedSearcher.getBlockHash(permutation.next());
                    shifts[hashValue & hashBitMask] = 0;
                }
            }
            return new SearchInfo(shifts, finalShifts, new MultiSequenceReverseMatcher(AbstractWuManberTunedSearcher.this.sequences));
        }
    }

    protected static final class SearchInfo {
        public final int[] shifts;
        public final int[] finalShifts;
        public final MultiSequenceMatcher matcher;

        public SearchInfo(int[] shifts, int[] finalShifts, MultiSequenceMatcher matcher) {
            this.shifts = shifts;
            this.finalShifts = finalShifts;
            this.matcher = matcher;
        }
    }
}

