/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.common;

import ch.docuteam.darc.mdconfig.LevelOfDescriptionSet;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.out.MessageDistributor;
import java.util.Observer;
import org.dom4j.tree.DefaultDocument;

public abstract class DocumentAbstract
extends DefaultDocument {
    private static final long serialVersionUID = 1L;
    protected String filePath;
    protected LevelOfDescriptionSet levels = new LevelOfDescriptionSet();
    protected boolean isModified = false;
    protected boolean isAtLeastOneFileNotReadable = false;
    protected boolean isAtLeastOneFileNotWritable = false;
    protected MessageDistributor observable = new MessageDistributor(false);

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String newFilePath) {
        this.filePath = newFilePath;
    }

    public LevelOfDescriptionSet getLevels() {
        return this.levels;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setIsModified() {
        this.isModified = true;
        StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
        Logger.debug((Object)("Modified by: " + caller.getClassName() + "." + caller.getMethodName()));
    }

    public void setIsNotModified() {
        this.isModified = false;
    }

    public boolean isAtLeastOneFileNotReadable() {
        return this.isAtLeastOneFileNotReadable;
    }

    public void setIsAtLeastOneFileNotReadable() {
        this.setIsAtLeastOneFileNotReadable(true);
    }

    public void setIsAtLeastOneFileNotReadable(boolean isAtLeastOneFileNotReadable) {
        this.isAtLeastOneFileNotReadable = isAtLeastOneFileNotReadable;
    }

    public boolean isAtLeastOneFileNotWritable() {
        return this.isAtLeastOneFileNotWritable;
    }

    public void setIsAtLeastOneFileNotWritable() {
        this.setIsAtLeastOneFileNotWritable(true);
    }

    public void setIsAtLeastOneFileNotWritable(boolean isAtLeastOneFileNotWritable) {
        this.isAtLeastOneFileNotWritable = isAtLeastOneFileNotWritable;
    }

    public abstract Type getDocumentType();

    public void distributeMessage(String message) {
        this.observable.distribute((Object)message);
    }

    public void addObserver(Observer observer) {
        if (observer != null) {
            this.observable.addObserver(observer);
        }
    }

    public void deleteObserver(Observer observer) {
        if (observer != null) {
            this.observable.deleteObserver(observer);
        }
    }

    public void deleteObservers() {
        this.observable.deleteObservers();
    }

    public static enum Type {
        METS,
        EAD,
        BAR,
        OTHER;

    }
}

