/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mets.metshdr;

import ch.docuteam.darc.common.NodeAbstract;
import ch.docuteam.darc.mets.metshdr.Header;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class Agent
extends NodeAbstract {
    protected String role;
    protected String type;
    protected String name;
    protected String note;

    protected Agent() {
    }

    protected Agent(Header parent, Element element) {
        this.document = parent.getDocument();
        this.parent = parent;
        this.element = element;
        this.role = element.attributeValue("ROLE");
        this.type = element.attributeValue("TYPE");
        this.name = this.getElementText("./METS:name", false);
        this.note = this.getElementText("./METS:note", false);
    }

    protected static List<Agent> parse(Header parent) {
        ArrayList<Agent> agentList = new ArrayList<Agent>();
        for (Object o : parent.getElement().selectNodes("./METS:agent")) {
            agentList.add(new Agent(parent, (Element)o));
        }
        return agentList;
    }

    public String getRole() {
        return this.role;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getNote() {
        return this.note;
    }

    public String toString() {
        return "[Agent:" + (this.name + "(") + (this.role + "/") + (this.type + ")]");
    }
}

