/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.database;

import java.io.IOException;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JDBCUtils {
    public static String toXML(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int colCount = rsmd.getColumnCount();
        StringBuffer xml = new StringBuffer();
        xml.append("<Results>");
        while (rs.next()) {
            xml.append("<Row>");
            for (int i = 1; i <= colCount; ++i) {
                String columnName = rsmd.getColumnName(i);
                Object value = rs.getObject(i);
                xml.append("<" + columnName + ">");
                if (value != null) {
                    xml.append(value.toString().trim());
                }
                xml.append("</" + columnName + ">");
            }
            xml.append("</Row>");
        }
        xml.append("</Results>");
        return xml.toString();
    }

    public static Document toDocument(ResultSet rs) throws ParserConfigurationException, SQLException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element results = doc.createElement("Results");
        doc.appendChild(results);
        ResultSetMetaData rsmd = rs.getMetaData();
        int colCount = rsmd.getColumnCount();
        while (rs.next()) {
            Element row = doc.createElement("Row");
            results.appendChild(row);
            for (int i = 1; i <= colCount; ++i) {
                String columnName = rsmd.getColumnName(i);
                Object value = rs.getObject(i);
                Element node = doc.createElement(columnName);
                node.appendChild(doc.createTextNode(value.toString()));
                row.appendChild(node);
            }
        }
        return doc;
    }

    public static Document appendColumnsToDocument(Document doc, ResultSet rs) throws ParserConfigurationException, SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int colCount = rsmd.getColumnCount();
        while (rs.next()) {
            for (int i = 1; i <= colCount; ++i) {
                String columnName = rsmd.getColumnName(i);
                Object value = rs.getObject(i);
                Element node = doc.createElement(columnName);
                node.appendChild(doc.createTextNode(value.toString()));
            }
        }
        return null;
    }

    public static Document toDoc(ResultSet rs) throws SQLException, FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        String xml = JDBCUtils.toXML(rs);
        StringReader reader = new StringReader(xml);
        InputSource source = new InputSource(reader);
        return builder.parse(source);
    }
}

