/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.services;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CacheManager<K, T> {
    private long timeToLive;
    private ConcurrentHashMap<String, Object> cacheMap;
    private static final ExLogger logger = ExLogger.getExLogger(CacheManager.class);
    private static final String CACHE_CLEANER = "CACHE_CLEANER";

    public CacheManager(long timeToLive, final long timerInterval) {
        this.timeToLive = timeToLive * 1000L;
        this.cacheMap = new ConcurrentHashMap();
        if (timeToLive > 0L && timerInterval > 0L) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(timerInterval * 1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        try {
                            CacheManager.this.cleanup();
                            continue;
                        }
                        catch (Throwable ex) {
                            logger.error("Problem while cleaning up Cache", ex, new String[0]);
                            CacheManager.this.waitBeforeRetrying();
                            continue;
                        }
                        break;
                    }
                }
            }, CACHE_CLEANER);
            t.setDaemon(true);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitBeforeRetrying() {
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
    }

    public Set<String> getKeys() {
        return this.cacheMap.keySet();
    }

    public void put(String key, T value) {
        this.cacheMap.put(key, new CacheObject(value));
    }

    public T get(K key) {
        CacheObject c = (CacheObject)this.cacheMap.get(key);
        if (c == null) {
            return null;
        }
        c.lastAccessed = System.currentTimeMillis();
        return c.value;
    }

    public void remove(K key) {
        this.cacheMap.remove(key);
    }

    public int size() {
        return this.cacheMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        int size;
        long now = System.currentTimeMillis();
        ArrayList deleteKey = null;
        ConcurrentHashMap<String, Object> concurrentHashMap = this.cacheMap;
        synchronized (concurrentHashMap) {
            Iterator itr = ((ConcurrentHashMap.KeySetView)this.cacheMap.keySet()).iterator();
            size = this.cacheMap.size();
            deleteKey = new ArrayList(size / 2 + 1);
            Object key = null;
            CacheObject c = null;
            while (itr.hasNext()) {
                key = itr.next();
                c = (CacheObject)this.cacheMap.get(key);
                if (c == null || now <= this.timeToLive + c.lastAccessed) continue;
                deleteKey.add(key);
            }
            for (Object key2 : deleteKey) {
                this.cacheMap.remove(key2);
            }
        }
        int cleanCount = deleteKey.size();
        long end = System.currentTimeMillis();
        if (cleanCount > 0 || end - now > 100L) {
            logger.info("Cache Cleaner cleanup took " + (end - now) + " msec. and cleaned " + cleanCount + " out of " + size);
        }
    }

    protected class CacheObject {
        public long lastAccessed = System.currentTimeMillis();
        public T value;

        protected CacheObject(T value) {
            this.value = value;
        }
    }
}

