/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.formatting;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.xml.XmlUtil;
import com.exlibris.core.sdk.config.CoreConfigurationManager;
import com.exlibris.core.sdk.formatting.MarcHandler;
import com.exlibris.digitool.repository.api.xmlbeans.Md;
import com.exlibris.digitool.repository.api.xmlbeans.MdName;
import com.exlibris.digitool.repository.api.xmlbeans.MdType;
import gov.loc.marc21.slim.RecordDocument;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public class MDRecordUtil {
    private static ExLogger logger = ExLogger.getExLogger(MDRecordUtil.class);

    public String getDtlNsPrefix(String mdType, String mdName, String nsUri) {
        if (!nsUri.endsWith("/")) {
            nsUri = nsUri + "/";
        }
        try {
            return CoreConfigurationManager.getInstance().getNamespacePrefix(mdType, nsUri);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private boolean isCofigured(String mdType, String mdName) {
        return CoreConfigurationManager.getInstance().getNamespacesByMetadataType(mdType) != null;
    }

    public Md normalizeMetadata(Md md) throws Exception {
        String mdval = this.normalizeMetadata(md.getValue(), md.getType(), md.getName());
        md.setValue(mdval);
        return md;
    }

    public String normalizeMetadata(String xmlStr, String mdType, String mdName) throws Exception {
        mdType = mdType.toLowerCase();
        Map<String, String> changemap = new HashMap();
        Map nsmap = XmlUtil.getPrefixesAndNsInUse(xmlStr);
        if (!this.isCofigured(mdType, mdName)) {
            if (nsmap == null || nsmap.size() == 0) {
                return xmlStr;
            }
            changemap = nsmap;
        } else {
            for (String nsuri : nsmap.keySet()) {
                String dtlPref = this.getDtlNsPrefix(mdType, mdName, nsuri);
                if (dtlPref == null && nsuri.length() > 0) continue;
                changemap.put(nsuri, dtlPref);
            }
        }
        xmlStr = XmlUtil.replcaeNsPrefix(xmlStr, changemap);
        return xmlStr;
    }

    public static Object getMDRecordObject(Md md) {
        if (MDRecordUtil.isMarc(md)) {
            try {
                RecordDocument marcrecord = RecordDocument.Factory.parse(md.getValue());
                return new MarcHandler(marcrecord.getRecord());
            }
            catch (Exception e) {
                MDRecordUtil.logException(md, e);
                return null;
            }
        }
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read((Reader)new StringReader(md.getValue()));
            return document;
        }
        catch (Exception e) {
            MDRecordUtil.logException(md, e);
            return null;
        }
    }

    public void validate(Md md) throws Exception {
        String mid = md.getMid();
        if (mid == null || mid.length() == 0) {
            mid = md.getVmid();
        }
        if (MDRecordUtil.isMarc(md)) {
            RecordDocument.Factory.parse(md.getValue());
        }
        SAXReader reader = new SAXReader();
        reader.read((Reader)new StringReader(md.getValue()));
    }

    private static boolean isDc(Md md) {
        return md.getName().toLowerCase().equals(MdName.Member.DESCRIPTIVE.toString()) && md.getType().toLowerCase().equals(MdType.Member.DC.toString());
    }

    private static boolean isMarc(Md md) {
        return md.getName().toLowerCase().equals(MdName.Member.DESCRIPTIVE.toString()) && md.getType().toLowerCase().equals(MdType.Member.MARC.toString());
    }

    private static boolean isMods(Md md) {
        return md.getName().toLowerCase().equals(MdName.Member.DESCRIPTIVE.toString()) && md.getType().toLowerCase().equals(MdType.Member.MODS.toString());
    }

    private static void logException(Md md, Exception e) {
        logger.warn(DescriptorConstants.IN_UnableToParserMD, (Object)(md.getName() + ":" + md.getType()), (Object)md.getMid(), (Object)e.getMessage(), (Object)e.getMessage());
        logger.debug((Object)e.getCause(), new String[0]);
    }
}

