/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.utils;

import com.exlibris.core.infra.common.util.Checksummer;
import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.sdk.utils.FSDirUtil;
import com.exlibris.core.sdk.utils.FileUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FolderUtil {
    private static final int BULK_SIZE = 1000;
    private String m_folderId = null;
    protected String m_folderDir = null;
    private StringBuffer m_buffer = null;
    private BufferedOutputStream m_buffOutStream = null;

    protected FolderUtil(String folderDir, String folderId) {
        String bulk_folder = Math.round((Long.valueOf(folderId) - 1L) / 1000L) * 1000 + 1 + "-" + (Math.round((Long.valueOf(folderId) - 1L) / 1000L) * 1000 + 1000);
        this.m_folderId = folderId;
        this.m_buffer = new StringBuffer(100);
        this.m_folderDir = this.m_buffer.append(folderDir).append(FSDirUtil.SEPARATOR).append(bulk_folder).append(FSDirUtil.SEPARATOR).append(this.getFolderPrefix()).append(this.m_folderId).append(FSDirUtil.SEPARATOR).toString();
    }

    String getFolderPrefix() {
        return "dep_";
    }

    public boolean createNewDirStructure() {
        FileUtil.createFile(this.m_folderDir);
        return true;
    }

    public boolean isExists() {
        File f = new File(this.m_folderDir);
        return f.exists();
    }

    public void deleteDirStructure() throws IOException {
        FileUtil.forceDelete(this.m_folderDir);
    }

    public void resetDirStructure() throws IOException {
        this.deleteDirStructure();
        this.createNewDirStructure();
    }

    public boolean addFile(String sourcePath, String targetDir) throws IOException {
        if (targetDir == null) {
            return false;
        }
        FileUtil.copyFileToDirectory(sourcePath, targetDir);
        return true;
    }

    public boolean addFile(File sourcePath, String targetDir) throws IOException {
        if (targetDir == null) {
            return false;
        }
        FileUtil.copyFileToDirectory(sourcePath, new File(targetDir));
        return true;
    }

    public String addFile(InputStream source, String fileName, String targetDir) throws Exception {
        if (targetDir == null) {
            return null;
        }
        File file = new File(targetDir + fileName);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        this.m_buffOutStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            Checksummer checksum = new Checksummer(source, this.m_buffOutStream, true, false, false, false);
            checksum.createChecksumAndCopyFile();
            String string = checksum.getMD5();
            return string;
        }
        catch (Exception e) {
            throw new Exception("Unable to upload file", e);
        }
        finally {
            IOUtil.shutdownStream(this.m_buffOutStream);
        }
    }

    public boolean addFile(String fileContents, String fileNameWithExt, String targetDir) throws IOException {
        File file = new File(targetDir + fileNameWithExt);
        file.getParentFile().mkdirs();
        if (targetDir == null) {
            return false;
        }
        this.m_buffOutStream = new BufferedOutputStream(new FileOutputStream(targetDir + fileNameWithExt));
        IOUtil.copy(fileContents, (OutputStream)this.m_buffOutStream);
        this.m_buffOutStream.close();
        return true;
    }

    public boolean addFiles(String[] files, String targetDir) throws IOException {
        if (targetDir == null) {
            return false;
        }
        for (int i = 0; i < files.length; ++i) {
            FileUtil.copyFile(files[i], targetDir);
        }
        return true;
    }

    public boolean addFiles(List<String> files, String targetDir) throws IOException {
        if (targetDir == null) {
            return false;
        }
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            FileUtil.copyFile(files.get(i), targetDir);
        }
        return true;
    }

    public boolean removeAllFiles(String targetDir) throws IOException {
        if (targetDir == null) {
            return false;
        }
        FileUtil.cleanDirectory(targetDir);
        return true;
    }

    public boolean removeFile(String fileName, String targetDir) throws IOException {
        if (targetDir == null) {
            return false;
        }
        String lFile = targetDir + fileName;
        if (!new File(lFile).isFile()) {
            return false;
        }
        FileUtil.forceDelete(lFile);
        return true;
    }

    public boolean removeDir(String targetDir) throws IOException {
        if (targetDir == null) {
            return false;
        }
        if (!new File(targetDir).isDirectory()) {
            return false;
        }
        FileUtil.forceDelete(targetDir);
        return true;
    }

    public File[] getAllFiles(String targetDir) {
        return this.getAllFiles(targetDir, false);
    }

    public File[] getAllFiles(String targetDirPath, boolean recursive) {
        if (targetDirPath == null) {
            return null;
        }
        if (!recursive) {
            return new File(targetDirPath).listFiles(new FileUtil.FilesFilter());
        }
        ArrayList<File> toReturn = new ArrayList<File>();
        File[] files = new File(targetDirPath).listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File childFile = files[i];
                if (childFile.isDirectory()) {
                    File[] innerFiles = this.getAllFiles(childFile.getAbsolutePath(), recursive);
                    toReturn.addAll(Arrays.asList(innerFiles));
                    continue;
                }
                toReturn.add(childFile);
            }
        }
        return toReturn.toArray(new File[toReturn.size()]);
    }

    public File[] getAllDirectories(String targetDir) {
        if (!FileUtil.isFileExist(targetDir)) {
            File dir = new File(targetDir);
            dir.mkdirs();
        }
        if (targetDir == null) {
            return null;
        }
        return new File(targetDir).listFiles(new FileUtil.DirectoryFilter());
    }

    public long getFilesSize(String targetDir) {
        File[] files = this.getAllFiles(targetDir);
        long usage = 0L;
        for (int i = 0; i < files.length; ++i) {
            usage += files[i].length();
        }
        return usage;
    }

    public File getFile(String name, String targetDir) {
        if (targetDir == null) {
            return null;
        }
        return new File(targetDir + name);
    }

    public String getFolderDir() {
        return this.m_folderDir;
    }
}

