/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.matcher.multisequence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.byteseek.automata.State;
import net.byteseek.automata.trie.Trie;
import net.byteseek.automata.trie.TrieFactory;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.automata.SequenceMatcherTrieFactory;
import net.byteseek.matcher.multisequence.MultiSequenceMatcher;
import net.byteseek.matcher.multisequence.MultiSequenceUtils;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.utils.ArgUtils;

public final class TrieMultiSequenceMatcher
implements MultiSequenceMatcher {
    private static final TrieFactory<SequenceMatcher> DEFAULT_TRIE_FACTORY = new SequenceMatcherTrieFactory();
    private final Trie<SequenceMatcher> trie;

    public TrieMultiSequenceMatcher(Collection<? extends SequenceMatcher> matchers) {
        this(DEFAULT_TRIE_FACTORY, matchers);
    }

    public TrieMultiSequenceMatcher(TrieFactory<SequenceMatcher> factory, Collection<? extends SequenceMatcher> matchers) {
        ArgUtils.checkNullObject(factory, "factory");
        ArgUtils.checkNullOrEmptyCollection(matchers, "matchers");
        this.trie = factory.create(matchers);
    }

    @Override
    public Collection<SequenceMatcher> allMatches(WindowReader reader, long matchPosition) throws IOException {
        List<SequenceMatcher> result = Collections.emptyList();
        State state = this.trie.getInitialState();
        long currentPosition = matchPosition;
        Window window = reader.getWindow(matchPosition);
        while (window != null) {
            int windowLength = window.length();
            byte[] array = window.getArray();
            int windowPosition = reader.getWindowOffset(currentPosition);
            while (windowPosition < windowLength) {
                byte currentByte;
                if ((state = state.getNextState(currentByte = array[windowPosition++])) == null) {
                    return result;
                }
                if (!state.isFinal()) continue;
                Collection matching = state.getAssociations();
                if (result.isEmpty()) {
                    result = new ArrayList<SequenceMatcher>(matching.size() * 2);
                }
                result.addAll(matching);
            }
            currentPosition += (long)windowLength;
            window = reader.getWindow(matchPosition);
        }
        return result;
    }

    @Override
    public Collection<SequenceMatcher> allMatches(byte[] bytes, int matchPosition) {
        List<SequenceMatcher> result = Collections.emptyList();
        int noOfBytes = bytes.length;
        int minimumLength = this.trie.getMinimumLength();
        if (matchPosition >= minimumLength - 1 && matchPosition + minimumLength < noOfBytes) {
            State state = this.trie.getInitialState();
            int currentPosition = matchPosition;
            while (state != null && currentPosition < noOfBytes) {
                byte currentByte;
                if ((state = state.getNextState(currentByte = bytes[currentPosition++])) == null || !state.isFinal()) continue;
                Collection matching = state.getAssociations();
                if (result.isEmpty()) {
                    result = new ArrayList<SequenceMatcher>(matching.size() * 2);
                }
                result.addAll(matching);
            }
        }
        return result;
    }

    @Override
    public Collection<SequenceMatcher> allMatchesBackwards(WindowReader reader, long matchPosition) throws IOException {
        List<SequenceMatcher> result = Collections.emptyList();
        State state = this.trie.getInitialState();
        long currentPosition = matchPosition;
        Window window = reader.getWindow(matchPosition);
        while (window != null) {
            int windowLength = window.length();
            byte[] array = window.getArray();
            int windowPosition = reader.getWindowOffset(currentPosition);
            while (windowPosition >= 0) {
                byte currentByte;
                if ((state = state.getNextState(currentByte = array[windowPosition--])) == null) {
                    return result;
                }
                if (!state.isFinal()) continue;
                Collection matching = state.getAssociations();
                if (result.isEmpty()) {
                    result = new ArrayList<SequenceMatcher>(matching.size() * 2);
                }
                result.addAll(matching);
            }
            currentPosition -= (long)windowLength;
            window = reader.getWindow(matchPosition);
        }
        return result;
    }

    @Override
    public Collection<SequenceMatcher> allMatchesBackwards(byte[] bytes, int matchPosition) {
        List<SequenceMatcher> result = Collections.emptyList();
        int noOfBytes = bytes.length;
        int minimumLength = this.trie.getMinimumLength();
        if (matchPosition >= minimumLength - 1 && matchPosition + minimumLength < noOfBytes) {
            State state = this.trie.getInitialState();
            int currentPosition = matchPosition;
            while (state != null && currentPosition >= 0) {
                byte currentByte;
                if ((state = state.getNextState(currentByte = bytes[currentPosition--])) == null || !state.isFinal()) continue;
                Collection matching = state.getAssociations();
                if (result.isEmpty()) {
                    result = new ArrayList<SequenceMatcher>(matching.size() * 2);
                }
                result.addAll(matching);
            }
        }
        return result;
    }

    @Override
    public SequenceMatcher firstMatch(WindowReader reader, long matchPosition) throws IOException {
        State<SequenceMatcher> state = this.trie.getInitialState();
        long currentPosition = matchPosition;
        Window window = reader.getWindow(matchPosition);
        while (window != null) {
            int windowLength = window.length();
            byte[] array = window.getArray();
            int windowPosition = reader.getWindowOffset(currentPosition);
            while (windowPosition < windowLength) {
                byte currentByte;
                if ((state = state.getNextState(currentByte = array[windowPosition++])) == null) {
                    return null;
                }
                if (!state.isFinal()) continue;
                return this.getFirstAssociation(state);
            }
            currentPosition += (long)windowLength;
            window = reader.getWindow(matchPosition);
        }
        return null;
    }

    @Override
    public SequenceMatcher firstMatch(byte[] bytes, int matchPosition) {
        if (matchPosition >= 0) {
            int noOfBytes = bytes.length;
            State<SequenceMatcher> state = this.trie.getInitialState();
            int currentPosition = matchPosition;
            while (state != null && currentPosition < noOfBytes) {
                byte currentByte;
                if ((state = state.getNextState(currentByte = bytes[currentPosition++])) == null || !state.isFinal()) continue;
                return this.getFirstAssociation(state);
            }
        }
        return null;
    }

    @Override
    public SequenceMatcher firstMatchBackwards(WindowReader reader, long matchPosition) throws IOException {
        State<SequenceMatcher> state = this.trie.getInitialState();
        long currentPosition = matchPosition;
        Window window = reader.getWindow(matchPosition);
        while (window != null) {
            int windowLength = window.length();
            byte[] array = window.getArray();
            int windowPosition = reader.getWindowOffset(currentPosition);
            while (windowPosition >= 0) {
                byte currentByte;
                if ((state = state.getNextState(currentByte = array[windowPosition--])) == null) {
                    return null;
                }
                if (!state.isFinal()) continue;
                return this.getFirstAssociation(state);
            }
            currentPosition -= (long)windowLength;
            window = reader.getWindow(matchPosition);
        }
        return null;
    }

    @Override
    public SequenceMatcher firstMatchBackwards(byte[] bytes, int matchPosition) {
        int noOfBytes = bytes.length;
        if (matchPosition < noOfBytes) {
            State<SequenceMatcher> state = this.trie.getInitialState();
            int currentPosition = matchPosition;
            while (state != null && currentPosition >= 0) {
                byte currentByte;
                if ((state = state.getNextState(currentByte = bytes[currentPosition--])) == null || !state.isFinal()) continue;
                return this.getFirstAssociation(state);
            }
        }
        return null;
    }

    @Override
    public boolean matches(WindowReader reader, long matchPosition) throws IOException {
        return this.firstMatch(reader, matchPosition) != null;
    }

    @Override
    public boolean matches(byte[] bytes, int matchPosition) {
        return this.firstMatch(bytes, matchPosition) != null;
    }

    @Override
    public boolean matchesBackwards(WindowReader reader, long matchPosition) throws IOException {
        return this.firstMatchBackwards(reader, matchPosition) != null;
    }

    @Override
    public boolean matchesBackwards(byte[] bytes, int matchPosition) {
        return this.firstMatchBackwards(bytes, matchPosition) != null;
    }

    @Override
    public int getMinimumLength() {
        return this.trie.getMinimumLength();
    }

    @Override
    public int getMaximumLength() {
        return this.trie.getMaximumLength();
    }

    @Override
    public MultiSequenceMatcher reverse() {
        return new TrieMultiSequenceMatcher(MultiSequenceUtils.reverseMatchers(this.trie.getSequences()));
    }

    @Override
    public MultiSequenceMatcher newInstance(Collection<? extends SequenceMatcher> sequences) {
        return new TrieMultiSequenceMatcher(sequences);
    }

    @Override
    public List<SequenceMatcher> getSequenceMatchers() {
        return new ArrayList<SequenceMatcher>(this.trie.getSequences());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[sequences:" + this.trie.getSequences() + ']';
    }

    private SequenceMatcher getFirstAssociation(State<SequenceMatcher> state) {
        Iterator<SequenceMatcher> associationIterator = state.associationIterator();
        if (associationIterator.hasNext()) {
            return associationIterator.next();
        }
        return null;
    }
}

