/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.matcher.sequence;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.bytes.ByteMatcher;
import net.byteseek.matcher.bytes.OneByteMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.utils.ArgUtils;
import net.byteseek.utils.ByteUtils;

public final class ByteSequenceMatcher
implements SequenceMatcher {
    private final byte[] byteArray;
    private final int startArrayIndex;
    private final int endArrayIndex;

    public ByteSequenceMatcher(byte ... bytes) {
        ArgUtils.checkNullOrEmptyByteArray(bytes);
        this.byteArray = (byte[])bytes.clone();
        this.startArrayIndex = 0;
        this.endArrayIndex = this.byteArray.length;
    }

    public ByteSequenceMatcher(byte[] source, int startIndex, int endIndex) {
        this(1, source, startIndex, endIndex);
    }

    public ByteSequenceMatcher(int numberOfRepeats, byte[] source, int startIndex, int endIndex) {
        ArgUtils.checkNullOrEmptyByteArray(source);
        ArgUtils.checkIndexOutOfBounds(source.length, startIndex, endIndex);
        ArgUtils.checkPositiveInteger(numberOfRepeats, "numberOfRepeats");
        this.byteArray = ByteUtils.repeat(numberOfRepeats, source, startIndex, endIndex);
        this.startArrayIndex = 0;
        this.endArrayIndex = this.byteArray.length;
    }

    public ByteSequenceMatcher(ByteSequenceMatcher source, int startIndex, int endIndex) {
        ArgUtils.checkNullObject(source);
        ArgUtils.checkIndexOutOfBounds(source.length(), startIndex, endIndex);
        this.byteArray = source.byteArray;
        this.startArrayIndex = source.startArrayIndex + startIndex;
        this.endArrayIndex = source.startArrayIndex + endIndex;
    }

    public ByteSequenceMatcher(ReverseByteArrayMatcher toReverse) {
        ArgUtils.checkNullObject(toReverse);
        this.byteArray = toReverse.byteArray;
        this.startArrayIndex = toReverse.startArrayIndex;
        this.endArrayIndex = toReverse.endArrayIndex;
    }

    public ByteSequenceMatcher(List<ByteSequenceMatcher> matchers) {
        ArgUtils.checkNullOrEmptyCollectionNoNullElements(matchers);
        int totalLength = 0;
        for (ByteSequenceMatcher matcher : matchers) {
            totalLength += matcher.endArrayIndex;
        }
        this.byteArray = new byte[totalLength];
        int position = 0;
        for (ByteSequenceMatcher matcher : matchers) {
            System.arraycopy(matcher.byteArray, 0, this.byteArray, position, matcher.endArrayIndex);
            position += matcher.endArrayIndex;
        }
        this.startArrayIndex = 0;
        this.endArrayIndex = totalLength;
    }

    public ByteSequenceMatcher(SequenceMatcher matcher) {
        ArgUtils.checkNullObject(matcher);
        int finalLength = matcher.length();
        this.byteArray = new byte[finalLength];
        for (int matcherIndex = 0; matcherIndex < finalLength; ++matcherIndex) {
            ByteMatcher byteMatcher = matcher.getMatcherForPosition(matcherIndex);
            int numberOfMatcherBytes = byteMatcher.getNumberOfMatchingBytes();
            if (numberOfMatcherBytes != 1) {
                throw new IllegalArgumentException("The matcher passed in contains a matcher at position " + matcherIndex + " which matches more than one byte value: " + byteMatcher);
            }
            this.byteArray[matcherIndex] = byteMatcher.getMatchingBytes()[0];
        }
        this.startArrayIndex = 0;
        this.endArrayIndex = finalLength;
    }

    public ByteSequenceMatcher(byte byteValue, int numberOfBytes) {
        ArgUtils.checkPositiveInteger(numberOfBytes);
        this.byteArray = new byte[numberOfBytes];
        Arrays.fill(this.byteArray, byteValue);
        this.startArrayIndex = 0;
        this.endArrayIndex = numberOfBytes;
    }

    public ByteSequenceMatcher(byte byteValue) {
        this(byteValue, 1);
    }

    public ByteSequenceMatcher(String string) {
        this(string, Charset.defaultCharset());
    }

    public ByteSequenceMatcher(String string, Charset charset) {
        ArgUtils.checkNullOrEmptyString(string, "string");
        ArgUtils.checkNullObject(charset, "charset");
        this.byteArray = string.getBytes(charset);
        this.startArrayIndex = 0;
        this.endArrayIndex = this.byteArray.length;
    }

    @Override
    public boolean matches(WindowReader reader, long matchPosition) throws IOException {
        byte[] matchArray = this.byteArray;
        int matchStart = this.startArrayIndex;
        int matchEnd = this.endArrayIndex;
        int matchLength = matchEnd - matchStart;
        Window window = reader.getWindow(matchPosition);
        int matchPos = matchStart;
        int bytesMatchedSoFar = 0;
        while (window != null) {
            int finalMatchIndex;
            byte[] source = window.getArray();
            int offset = reader.getWindowOffset(matchPosition + (long)bytesMatchedSoFar);
            int finalWindowIndex = window.length();
            int sourceEnd = finalWindowIndex < (finalMatchIndex = offset + matchLength - bytesMatchedSoFar) ? finalWindowIndex : finalMatchIndex;
            for (int sourcePos = offset; sourcePos < sourceEnd; ++sourcePos) {
                if (source[sourcePos] == matchArray[matchPos++]) continue;
                return false;
            }
            if (matchPos >= matchEnd) {
                return true;
            }
            bytesMatchedSoFar = matchPos - matchStart;
            window = reader.getWindow(matchPosition + (long)bytesMatchedSoFar);
        }
        return false;
    }

    @Override
    public boolean matches(byte[] bytes, int matchPosition) {
        if (matchPosition + this.endArrayIndex - this.startArrayIndex <= bytes.length && matchPosition >= 0) {
            byte[] matchArray = this.byteArray;
            int endingIndex = this.endArrayIndex;
            int position = matchPosition;
            for (int matchIndex = this.startArrayIndex; matchIndex < endingIndex; ++matchIndex) {
                if (matchArray[matchIndex] == bytes[position++]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesNoBoundsCheck(byte[] bytes, int matchPosition) {
        int position = matchPosition;
        byte[] matchArray = this.byteArray;
        int endingIndex = this.endArrayIndex;
        for (int matchIndex = this.startArrayIndex; matchIndex < endingIndex; ++matchIndex) {
            if (matchArray[matchIndex] == bytes[position++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int length() {
        return this.endArrayIndex - this.startArrayIndex;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.toRegularExpression(true) + ']';
    }

    @Override
    public String toRegularExpression(boolean prettyPrint) {
        return ByteUtils.bytesToString(prettyPrint, this.byteArray, this.startArrayIndex, this.endArrayIndex);
    }

    @Override
    public ByteMatcher getMatcherForPosition(int position) {
        ArgUtils.checkIndexOutOfBounds(this.length(), position);
        return OneByteMatcher.valueOf(this.byteArray[position + this.startArrayIndex]);
    }

    @Override
    public SequenceMatcher reverse() {
        return new ReverseByteArrayMatcher(this);
    }

    @Override
    public SequenceMatcher subsequence(int beginIndex, int endIndex) {
        ArgUtils.checkIndexOutOfBounds(this.length(), beginIndex, endIndex);
        int subsequenceLength = endIndex - beginIndex;
        if (subsequenceLength == 1) {
            return OneByteMatcher.valueOf(this.byteArray[this.startArrayIndex + beginIndex]);
        }
        if (subsequenceLength == this.length()) {
            return this;
        }
        return new ByteSequenceMatcher(this, beginIndex, endIndex);
    }

    @Override
    public SequenceMatcher subsequence(int beginIndex) {
        return this.subsequence(beginIndex, this.length());
    }

    @Override
    public SequenceMatcher repeat(int numberOfRepeats) {
        ArgUtils.checkPositiveInteger(numberOfRepeats);
        if (numberOfRepeats == 1) {
            return this;
        }
        return new ByteSequenceMatcher(numberOfRepeats, this.byteArray, this.startArrayIndex, this.endArrayIndex);
    }

    @Override
    public Iterator<ByteMatcher> iterator() {
        return new ByteMatcherIterator();
    }

    public static final class ReverseByteArrayMatcher
    implements SequenceMatcher {
        private final byte[] byteArray;
        private final int startArrayIndex;
        private final int endArrayIndex;

        public ReverseByteArrayMatcher(ByteSequenceMatcher toReverse) {
            ArgUtils.checkNullObject(toReverse);
            this.byteArray = toReverse.byteArray;
            this.startArrayIndex = toReverse.startArrayIndex;
            this.endArrayIndex = toReverse.endArrayIndex;
        }

        public ReverseByteArrayMatcher(byte ... bytes) {
            ArgUtils.checkNullOrEmptyByteArray(bytes);
            this.byteArray = (byte[])bytes.clone();
            this.startArrayIndex = 0;
            this.endArrayIndex = bytes.length;
        }

        public ReverseByteArrayMatcher(ReverseByteArrayMatcher source, int startIndex, int endIndex) {
            ArgUtils.checkNullObject(source);
            ArgUtils.checkIndexOutOfBounds(source.length(), startIndex, endIndex);
            this.byteArray = source.byteArray;
            this.startArrayIndex = source.startArrayIndex + source.length() - endIndex;
            this.endArrayIndex = source.endArrayIndex - startIndex;
        }

        public ReverseByteArrayMatcher(int numberOfRepeats, byte[] source, int startIndex, int endIndex) {
            ArgUtils.checkNullOrEmptyByteArray(source);
            ArgUtils.checkIndexOutOfBounds(source.length, startIndex, endIndex);
            ArgUtils.checkPositiveInteger(numberOfRepeats, "numberOfRepeats");
            this.byteArray = ByteUtils.repeat(numberOfRepeats, source, startIndex, endIndex);
            this.startArrayIndex = 0;
            this.endArrayIndex = this.byteArray.length;
        }

        @Override
        public boolean matches(WindowReader reader, long matchPosition) throws IOException {
            int matchStart = this.startArrayIndex;
            int matchLength = this.endArrayIndex - this.startArrayIndex;
            int matchEnd = this.endArrayIndex - 1;
            byte[] matchArray = this.byteArray;
            Window window = reader.getWindow(matchPosition);
            int matchPos = matchEnd;
            int bytesMatchedSoFar = 0;
            while (window != null) {
                int finalMatchIndex;
                byte[] source = window.getArray();
                int offset = reader.getWindowOffset(matchPosition + (long)bytesMatchedSoFar);
                int finalWindowIndex = window.length();
                int sourceEnd = finalWindowIndex < (finalMatchIndex = offset + matchLength - bytesMatchedSoFar) ? finalWindowIndex : finalMatchIndex;
                for (int sourcePos = offset; sourcePos < sourceEnd; ++sourcePos) {
                    if (source[sourcePos] == matchArray[matchPos--]) continue;
                    return false;
                }
                if (matchPos < matchStart) {
                    return true;
                }
                bytesMatchedSoFar = matchEnd - matchPos;
                window = reader.getWindow(matchPosition + (long)bytesMatchedSoFar);
            }
            return false;
        }

        @Override
        public boolean matches(byte[] bytes, int matchPosition) {
            if (matchPosition + this.length() <= bytes.length && matchPosition >= 0) {
                byte[] matchArray = this.byteArray;
                int endingIndex = this.startArrayIndex;
                int position = matchPosition;
                for (int matchIndex = this.endArrayIndex - 1; matchIndex >= endingIndex; --matchIndex) {
                    if (matchArray[matchIndex] == bytes[position++]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean matchesNoBoundsCheck(byte[] bytes, int matchPosition) {
            int position = matchPosition;
            byte[] matchArray = this.byteArray;
            int endingIndex = this.startArrayIndex;
            for (int matchIndex = this.endArrayIndex - 1; matchIndex >= endingIndex; --matchIndex) {
                if (matchArray[matchIndex] == bytes[position++]) continue;
                return false;
            }
            return true;
        }

        @Override
        public int length() {
            return this.endArrayIndex - this.startArrayIndex;
        }

        public String toString() {
            return "ByteSequenceMatcher." + this.getClass().getSimpleName() + '[' + this.toRegularExpression(true) + ']';
        }

        @Override
        public String toRegularExpression(boolean prettyPrint) {
            return ByteUtils.bytesToString(prettyPrint, ByteUtils.reverseArraySubsequence(this.byteArray, this.startArrayIndex, this.endArrayIndex));
        }

        @Override
        public ByteMatcher getMatcherForPosition(int position) {
            ArgUtils.checkIndexOutOfBounds(this.length(), position);
            return OneByteMatcher.valueOf(this.byteArray[this.endArrayIndex - 1 - position]);
        }

        @Override
        public SequenceMatcher reverse() {
            return new ByteSequenceMatcher(this);
        }

        @Override
        public SequenceMatcher subsequence(int beginIndex, int endIndex) {
            ArgUtils.checkIndexOutOfBounds(this.length(), beginIndex, endIndex);
            int subsequenceLength = endIndex - beginIndex;
            if (subsequenceLength == this.length()) {
                return this;
            }
            if (subsequenceLength == 1) {
                return OneByteMatcher.valueOf(this.byteArray[this.endArrayIndex - beginIndex - 1]);
            }
            return new ReverseByteArrayMatcher(this, beginIndex, endIndex);
        }

        @Override
        public SequenceMatcher subsequence(int beginIndex) {
            return this.subsequence(beginIndex, this.length());
        }

        @Override
        public SequenceMatcher repeat(int numberOfRepeats) {
            ArgUtils.checkPositiveInteger(numberOfRepeats);
            if (numberOfRepeats == 1) {
                return this;
            }
            return new ReverseByteArrayMatcher(numberOfRepeats, this.byteArray, this.startArrayIndex, this.endArrayIndex);
        }

        @Override
        public Iterator<ByteMatcher> iterator() {
            return new ReverseByteMatcherIterator();
        }

        private final class ReverseByteMatcherIterator
        implements Iterator<ByteMatcher> {
            int position;

            private ReverseByteMatcherIterator() {
                this.position = ReverseByteArrayMatcher.this.endArrayIndex;
            }

            @Override
            public boolean hasNext() {
                return this.position > ReverseByteArrayMatcher.this.startArrayIndex;
            }

            @Override
            public ByteMatcher next() {
                if (this.hasNext()) {
                    return OneByteMatcher.valueOf(ReverseByteArrayMatcher.this.byteArray[--this.position]);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Byte matchers cannot be removed from a ReverseByteSequenceMatcher");
            }
        }
    }

    private final class ByteMatcherIterator
    implements Iterator<ByteMatcher> {
        int position;

        private ByteMatcherIterator() {
            this.position = ByteSequenceMatcher.this.startArrayIndex;
        }

        @Override
        public boolean hasNext() {
            return this.position < ByteSequenceMatcher.this.endArrayIndex;
        }

        @Override
        public ByteMatcher next() {
            if (this.hasNext()) {
                return OneByteMatcher.valueOf(ByteSequenceMatcher.this.byteArray[this.position++]);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Byte matchers cannot be removed from a ByteSequenceMatcher");
        }
    }
}

