/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.Parser;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfStream;
import edu.harvard.hul.ois.jhove.module.pdf.Stream;
import edu.harvard.hul.ois.jhove.module.pdf.StreamTokenizer;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;

public class ObjectStream {
    private PdfStream _ostrm;
    private PdfDictionary _dict;
    private int _numObjects;
    private int _firstOffset;
    private Parser _parser;
    private RandomAccessFile _raf;
    private Map _index;

    public ObjectStream(PdfStream ostrm, RandomAccessFile raf) {
        this._ostrm = ostrm;
        this._raf = raf;
        this._dict = ostrm.getDict();
        this._parser = new Parser(new StreamTokenizer(raf, this._ostrm.getStream()));
    }

    public boolean isValid() {
        try {
            PdfObject obj = this._dict.get("Type");
            String typeStr = null;
            if (obj instanceof PdfSimpleObject) {
                typeStr = ((PdfSimpleObject)obj).getStringValue();
            }
            if (!"ObjStm".equals(typeStr)) {
                return false;
            }
            obj = this._dict.get("N");
            if (!(obj instanceof PdfSimpleObject)) {
                return false;
            }
            this._numObjects = ((PdfSimpleObject)obj).getIntValue();
            obj = this._dict.get("First");
            if (!(obj instanceof PdfSimpleObject)) {
                return false;
            }
            this._firstOffset = ((PdfSimpleObject)obj).getIntValue();
            obj = this._dict.get("Extends");
            if (obj != null) {
                // empty if block
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void readIndex() throws PdfException, IOException {
        Stream strm = this._ostrm.getStream();
        strm.setFilters(this._ostrm.getFilters());
        strm.initRead(this._raf);
        this._index = new HashMap(this._numObjects);
        for (int i = 0; i < this._numObjects; ++i) {
            Integer onum = new Integer(strm.readAsciiInt());
            Integer offset = new Integer(strm.readAsciiInt());
            this._index.put(onum, offset);
        }
    }

    public PdfObject getObject(int objnum) throws PdfException {
        Integer onum = new Integer(objnum);
        Integer off = (Integer)this._index.get(onum);
        try {
            if (off != null) {
                int offset = off;
                this._parser.seek(offset + this._firstOffset);
                PdfObject object = this._parser.readObject(false);
                object.setObjNumber(objnum);
                return object;
            }
            return null;
        }
        catch (IOException e) {
            throw new PdfMalformedException("Offset out of bounds in object stream");
        }
    }
}

