/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.formatting;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.sdk.formatting.DublinCore;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class DublinCoreFactory {
    private static final ExLogger log = ExLogger.getExLogger(DublinCoreFactory.class);
    private static DublinCoreFactory m_instance = new DublinCoreFactory();
    public static final String DC_ROOT = "<dc:record";
    public static final String RECORD = "<record";
    public static final String DC_PREFIX = "<dc:";
    public static final String DCTERM_PREFIX = "<dcterms:";

    private DublinCoreFactory() {
    }

    public static DublinCoreFactory getInstance() {
        return m_instance;
    }

    public DublinCore createDocumentwMultiFields(Map<String, List<String>> map) {
        DublinCore dc = new DublinCore();
        if (map == null) {
            return dc;
        }
        Iterator<String> itr = map.keySet().iterator();
        while (itr.hasNext()) {
            String key = itr.next().toString();
            List<String> valList = map.get(key);
            for (String value : valList) {
                dc.addElement(key, value);
            }
        }
        return dc;
    }

    public DublinCore createDocument(Map map) {
        DublinCore dc = new DublinCore();
        if (map == null) {
            return dc;
        }
        Iterator itr = map.keySet().iterator();
        while (itr.hasNext()) {
            String key = itr.next().toString();
            String val = (String)map.get(key);
            dc.addElement(key, val);
        }
        return dc;
    }

    public DublinCore createDocument() {
        return new DublinCore();
    }

    public DublinCore createDocument(String xml) throws DocumentException {
        DublinCore dc = new DublinCore();
        SAXReader reader = new SAXReader();
        Document document = reader.read((Reader)new StringReader(xml));
        Element record = document.getRootElement();
        String recordNode = record.asXML();
        if (recordNode.startsWith(DC_ROOT) || recordNode.startsWith(RECORD)) {
            return new DublinCore(xml);
        }
        Iterator eitr = record.elementIterator();
        Element dcDoc = dc.getDocument().getRootElement();
        while (eitr.hasNext()) {
            Element element = (Element)eitr.next();
            String node = element.asXML();
            if (!node.startsWith(DC_PREFIX) && !node.startsWith(DCTERM_PREFIX)) {
                eitr = element.elementIterator();
                continue;
            }
            dcDoc.add(element.createCopy());
        }
        return dc;
    }

    public DublinCore normalizeRoot(String xml) throws DocumentException {
        DublinCore dc = new DublinCore();
        SAXReader reader = new SAXReader();
        Document document = reader.read((Reader)new StringReader(xml));
        Element record = document.getRootElement();
        Iterator eitr = record.elementIterator();
        Element dcDoc = dc.getDocument().getRootElement();
        while (eitr.hasNext()) {
            Element element = (Element)eitr.next();
            dcDoc.add(element.createCopy());
        }
        return dc;
    }

    public static void main(String[] args) {
        HashMap<String, String[]> hash = new HashMap<String, String[]>();
        String[] s = new String[]{"I am alt"};
        hash.put("dcterms:alternative@DCMIType:hello", s);
        s = new String[]{"I am subject"};
        hash.put("dc:subject", s);
        s = new String[]{"I am kuku"};
        hash.put("dc:title@DCMIType:kuku", s);
        DublinCore dc = DublinCoreFactory.getInstance().createDocument(hash);
        dc.addElement(10, "title", "hello title");
        dc.addElement(20, "alternative", "hello alternative");
        dc.addElement(10, "identifier", "dcterms:ISBN", "hello identifier");
        dc.getDcValue("title");
        dc.getDctermsValue("alternative");
    }
}

