/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.matcher.sequence;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.matcher.bytes.AnyByteMatcher;
import net.byteseek.matcher.bytes.ByteMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.utils.ArgUtils;

public final class FixedGapMatcher
implements SequenceMatcher {
    private static final String ONE_ANY_MATCHER = ".";
    private static final String TWO_ANY_MATCHERS = "..";
    private static final String THREE_ANY_MATCHERS = "...";
    private final int length;

    public FixedGapMatcher(int gapLength) {
        ArgUtils.checkPositiveInteger(gapLength);
        this.length = gapLength;
    }

    @Override
    public ByteMatcher getMatcherForPosition(int position) {
        ArgUtils.checkIndexOutOfBounds(this.length, position);
        return AnyByteMatcher.ANY_BYTE_MATCHER;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public String toRegularExpression(boolean prettyPrint) {
        switch (this.length) {
            case 1: {
                return ONE_ANY_MATCHER;
            }
            case 2: {
                return TWO_ANY_MATCHERS;
            }
            case 3: {
                return THREE_ANY_MATCHERS;
            }
        }
        return String.format(".{%d}", this.length);
    }

    @Override
    public boolean matches(WindowReader reader, long matchPosition) throws IOException {
        return reader.getWindow(matchPosition) != null && reader.getWindow(matchPosition + (long)this.length - 1L) != null;
    }

    @Override
    public boolean matches(byte[] bytes, int matchPosition) {
        return matchPosition + this.length < bytes.length && matchPosition >= 0;
    }

    @Override
    public boolean matchesNoBoundsCheck(byte[] bytes, int matchPosition) {
        return true;
    }

    @Override
    public FixedGapMatcher reverse() {
        return this;
    }

    @Override
    public SequenceMatcher subsequence(int startIndex, int endIndex) {
        ArgUtils.checkIndexOutOfBounds(this.length, startIndex, endIndex);
        if (endIndex - startIndex == 1) {
            return AnyByteMatcher.ANY_BYTE_MATCHER;
        }
        return new FixedGapMatcher(endIndex - startIndex);
    }

    @Override
    public SequenceMatcher subsequence(int beginIndex) {
        return this.subsequence(beginIndex, this.length);
    }

    @Override
    public SequenceMatcher repeat(int numberOfRepeats) {
        ArgUtils.checkPositiveInteger(numberOfRepeats);
        if (numberOfRepeats == 1) {
            return this;
        }
        return new FixedGapMatcher(this.length * numberOfRepeats);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.toRegularExpression(true) + ']';
    }

    @Override
    public Iterator<ByteMatcher> iterator() {
        return new FixedGapIterator();
    }

    private class FixedGapIterator
    implements Iterator<ByteMatcher> {
        private int count;

        private FixedGapIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < FixedGapMatcher.this.length;
        }

        @Override
        public ByteMatcher next() {
            if (this.hasNext()) {
                ++this.count;
                return AnyByteMatcher.ANY_BYTE_MATCHER;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Byte matchers cannot be removed from a FixedGapMatcher");
        }
    }
}

