/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.sort;

import java.text.Collator;
import java.util.Comparator;
import javax.swing.DefaultRowSorter;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.sort.DefaultSortController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableSortController<M extends TableModel>
extends DefaultSortController<M> {
    private M tableModel;

    public TableSortController() {
        this(null);
    }

    public TableSortController(M model) {
        this.setModel(model);
    }

    public void setModel(M model) {
        this.tableModel = model;
        if (model != null) {
            this.cachedModelRowCount = model.getRowCount();
        }
        this.setModelWrapper(new TableRowSorterModelWrapper());
    }

    @Override
    public Comparator<?> getComparator(int column) {
        Comparator<?> comparator = super.getComparator(column);
        if (comparator != null) {
            return comparator;
        }
        Class<?> columnClass = ((TableModel)this.getModel()).getColumnClass(column);
        if (columnClass == String.class) {
            return Collator.getInstance();
        }
        if (Comparable.class.isAssignableFrom(columnClass)) {
            return COMPARABLE_COMPARATOR;
        }
        return Collator.getInstance();
    }

    @Override
    protected boolean useToString(int column) {
        Comparator<?> comparator = super.getComparator(column);
        if (comparator != null) {
            return false;
        }
        Class<?> columnClass = ((TableModel)this.getModel()).getColumnClass(column);
        if (columnClass == String.class) {
            return false;
        }
        return !Comparable.class.isAssignableFrom(columnClass);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TableRowSorterModelWrapper
    extends DefaultRowSorter.ModelWrapper<M, Integer> {
        private TableRowSorterModelWrapper() {
        }

        @Override
        public M getModel() {
            return TableSortController.this.tableModel;
        }

        @Override
        public int getColumnCount() {
            return TableSortController.this.tableModel == null ? 0 : TableSortController.this.tableModel.getColumnCount();
        }

        @Override
        public int getRowCount() {
            return TableSortController.this.tableModel == null ? 0 : TableSortController.this.tableModel.getRowCount();
        }

        @Override
        public Object getValueAt(int row, int column) {
            return TableSortController.this.tableModel.getValueAt(row, column);
        }

        @Override
        public String getStringValueAt(int row, int column) {
            return TableSortController.this.getStringValueProvider().getStringValue(row, column).getString(this.getValueAt(row, column));
        }

        @Override
        public Integer getIdentifier(int index) {
            return index;
        }
    }
}

