/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.apf;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiSingleImageRasterEncoder;
import com.sun.jimi.core.encoder.apf.APFEncoderFactory;
import com.sun.jimi.core.raster.JimiRasterImage;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class APFEncoder
extends JimiSingleImageRasterEncoder {
    public void doEncodeImage(JimiRasterImage jimiRasterImage, OutputStream outputStream) throws JimiException, IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(outputStream));
        this.writeHeader(jimiRasterImage, dataOutputStream);
        this.writeImageData(jimiRasterImage, dataOutputStream);
        dataOutputStream.flush();
    }

    protected void writeHeader(JimiRasterImage jimiRasterImage, DataOutputStream dataOutputStream) throws JimiException, IOException {
        dataOutputStream.write(APFEncoderFactory.FORMAT_SIGNATURE);
        dataOutputStream.writeInt(jimiRasterImage.getWidth());
        dataOutputStream.writeInt(jimiRasterImage.getHeight());
    }

    protected void writeImageData(JimiRasterImage jimiRasterImage, DataOutputStream dataOutputStream) throws JimiException, IOException {
        int[] nArray = new int[jimiRasterImage.getWidth()];
        int n = 0;
        while (n < jimiRasterImage.getHeight()) {
            jimiRasterImage.getRowRGB(n, nArray, 0);
            int n2 = 0;
            while (n2 < jimiRasterImage.getWidth()) {
                dataOutputStream.writeInt(nArray[n2]);
                ++n2;
            }
            ++n;
        }
    }
}

