/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.xml;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

public class XmlDeclStream
extends FilterInputStream {
    private static final int CR = 13;
    private static final int LF = 10;
    private StringBuffer declBuf = null;
    private StringBuffer refBuf;
    private boolean seenChars = false;
    private String _version;
    private String _encoding;
    private String _standalone;
    private List<Integer> _charRefs = new LinkedList<Integer>();
    protected boolean _lineEndCR = false;
    protected boolean _lineEndLF = false;
    protected boolean _lineEndCRLF = false;
    protected int _prevChar = 0;

    public XmlDeclStream(InputStream strm) {
        super(strm);
    }

    @Override
    public int read() throws IOException {
        int retval = super.read();
        if (retval > 0) {
            this.process(retval);
        }
        return retval;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int nbytes = super.read(b);
        for (int i = 0; i < nbytes; ++i) {
            this.process(b[i]);
        }
        return nbytes;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int nbytes = super.read(b, off, len);
        for (int i = off; i < off + nbytes; ++i) {
            this.process(b[i]);
        }
        return nbytes;
    }

    public List<Integer> getCharacterReferences() {
        return this._charRefs;
    }

    public String getVersion() {
        return this._version;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public String getStandalone() {
        return this._standalone;
    }

    private void process(int b) {
        this.checkLineEnd(b);
        this._prevChar = b;
        if (!this.seenChars || this.declBuf != null) {
            if (this.declBuf == null && b == 60) {
                this.declBuf = new StringBuffer("<");
            } else if (this.declBuf != null) {
                this.declBuf.append((char)b);
                if ((char)b == '>') {
                    this.processDecl();
                    this.declBuf = null;
                }
            }
        }
        if (this.refBuf == null && b == 38) {
            this.refBuf = new StringBuffer("&");
        } else if (this.refBuf != null) {
            if (this.refBuf.length() == 1 && b != 35) {
                this.refBuf = null;
            } else if (b == 59) {
                this.processRef();
                this.refBuf = null;
            } else {
                this.refBuf.append((char)b);
            }
        }
        this.seenChars = true;
    }

    private void processDecl() {
        String decl = this.declBuf.toString();
        if (!decl.startsWith("<?xml") || !decl.endsWith("?>")) {
            this.declBuf = null;
        } else {
            int off1 = 0;
            int off = decl.indexOf("version");
            if (off > 0) {
                this._version = this.extractParam(decl, off);
                off1 = off;
            }
            if ((off = decl.indexOf("encoding", off1)) > 0) {
                this._encoding = this.extractParam(decl, off);
                off1 = off;
            }
            if ((off = decl.indexOf("standalone", off1)) > 0) {
                this._standalone = this.extractParam(decl, off);
            }
        }
    }

    private void processRef() {
        boolean isHex = this.refBuf.charAt(2) == 'x';
        int val = 0;
        StringBuffer refBuf1 = this.refBuf;
        this.refBuf = null;
        if (isHex) {
            for (int i = 3; i < refBuf1.length(); ++i) {
                char ch = Character.toUpperCase(refBuf1.charAt(i));
                if (ch >= 'A' && ch <= 'F') {
                    val = 16 * val + (ch - 65 + 10);
                    continue;
                }
                if (ch >= '0' && ch <= '9') {
                    val = 16 * val + (ch - 48);
                    continue;
                }
                return;
            }
        } else {
            for (int i = 2; i < refBuf1.length(); ++i) {
                char ch = refBuf1.charAt(i);
                if (ch < '0' || ch > '9') {
                    return;
                }
                val = 10 * val + (ch - 48);
            }
        }
        this._charRefs.add(new Integer(val));
    }

    private String extractParam(String str, int off) {
        int equIdx = str.indexOf(61, off);
        if (equIdx == -1) {
            return null;
        }
        boolean singleQuote = false;
        boolean doubleQuote = false;
        int startOff = -1;
        for (int i = equIdx + 1; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (startOff < 0 || singleQuote || doubleQuote) continue;
                return str.substring(startOff, i + 1);
            }
            if (ch == '\'' && !doubleQuote) {
                if (!singleQuote) {
                    singleQuote = true;
                    startOff = i + 1;
                    continue;
                }
                return str.substring(startOff, i);
            }
            if (ch == '\"' && !singleQuote) {
                if (!doubleQuote) {
                    doubleQuote = true;
                    startOff = i + 1;
                    continue;
                }
                return str.substring(startOff, i);
            }
            if (startOff >= 0) continue;
            startOff = i;
        }
        return null;
    }

    protected void checkLineEnd(int ch) {
        if (ch == 10) {
            if (this._prevChar == 13) {
                this._lineEndCRLF = true;
            } else {
                this._lineEndLF = true;
            }
        } else if (this._prevChar == 13) {
            this._lineEndCR = true;
        }
    }

    public String getKindOfLineEnd() {
        if (this._lineEndCR || this._lineEndLF || this._lineEndCRLF) {
            if (this._lineEndCRLF) {
                return "CRLF";
            }
            if (this._lineEndCR) {
                return "CR";
            }
            if (this._lineEndLF) {
                return "LF";
            }
        }
        return null;
    }
}

