/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.converter;

import ch.docuteam.converter.exceptions.PDFToolsWSException;
import ch.docuteam.tools.file.ResourceUtil;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.string.StringUtil;
import com.pdf_tools.ws.o2p.ConversionResult;
import com.pdf_tools.ws.o2p.Converter;
import com.pdf_tools.ws.o2p.ConverterSoap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.soap.SOAPBinding;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;

public class PDFToolsConverterWSClient {
    private static final String DEFAULT_SERVICE_PROPERTY_FILEPATH = "config/pdfToolsConverterWS.properties";
    private static final String PROPERTY_SERVICE_URL = "pdftoolsWS.url";
    private static final String PROPERTY_SERVICE_CREDENTIALS_USERNAME = "pdftoolsWS.username";
    private static final String PROPERTY_SERVICE_CREDENTIALS_PASSWORD = "pdftoolsWS.password";
    private static final String PROPERTY_SERVICE_TIMEOUT = "pdftoolsWS.timeout";
    private static final String PROPERTY_SERVICE_MTOM = "pdftoolsWS.mtom";
    private static String serviceProviderURL;
    private static String username;
    private static String password;
    private static long timeout;
    private static boolean mtom;
    static final String OPTION_SERVICE_PROVIDER_PROPERTIES_FILE = "spPropertiesFile";
    static final String OPTION_INPUT_FILE = "path-to-input";
    static final String OPTION_OUTPUT_FILE = "path-to-output";
    static final String OPTION_CONVERTER = "j";
    static final String OPTION_BYNAME = "byName";
    static final String OPTION_XMP_DATA = "ax";
    static final String OPTION_PARAM_NAME = "param-name";
    static final String OPTION_PARAM_FILE = "param-file";
    private static OptionParser parser;
    private static OptionSet options;
    private static ConverterSoap webService;

    public static void main(String ... args) throws IOException, PDFToolsWSException {
        parser = new OptionParser();
        parser.accepts(OPTION_INPUT_FILE).withRequiredArg().required().describedAs("path-to-input-document");
        parser.accepts(OPTION_OUTPUT_FILE).withRequiredArg().required().describedAs("path-to-output-file");
        parser.accepts(OPTION_CONVERTER).withRequiredArg().describedAs("ConverterOptions");
        parser.accepts(OPTION_BYNAME).withRequiredArg().describedAs("pass files by path name");
        parser.accepts(OPTION_XMP_DATA).withRequiredArg().describedAs("xmpdata.xml");
        parser.accepts(OPTION_SERVICE_PROVIDER_PROPERTIES_FILE).withRequiredArg().describedAs("path-to-pdfToolsConverterWS.properties");
        parser.accepts(OPTION_PARAM_NAME).withRequiredArg().describedAs(OPTION_PARAM_NAME);
        parser.accepts(OPTION_PARAM_FILE).withRequiredArg().describedAs(OPTION_PARAM_FILE);
        PDFToolsConverterWSClient.parseOptions(args, PDFToolsConverterWSClient.class);
        String inputFilePath = (String)options.valueOf(OPTION_INPUT_FILE);
        String outputFilePath = (String)options.valueOf(OPTION_OUTPUT_FILE);
        String servicePropertyFilePath = (String)options.valueOf(OPTION_SERVICE_PROVIDER_PROPERTIES_FILE);
        String xmpFilePath = null;
        if (options.valueOf(OPTION_XMP_DATA) != null) {
            xmpFilePath = (String)options.valueOf(OPTION_XMP_DATA);
        }
        String converterOptions = "";
        if (options.valueOf(OPTION_CONVERTER) != null) {
            converterOptions = (String)options.valueOf(OPTION_CONVERTER);
        }
        Boolean byName = Boolean.FALSE;
        if (options.valueOf(OPTION_BYNAME) != null) {
            byName = Boolean.valueOf((String)options.valueOf(OPTION_BYNAME));
        }
        String paramName = null;
        if (options.valueOf(OPTION_PARAM_NAME) != null) {
            paramName = (String)options.valueOf(OPTION_PARAM_NAME);
        }
        String paramFile = null;
        if (options.valueOf(OPTION_PARAM_FILE) != null) {
            paramFile = (String)options.valueOf(OPTION_PARAM_FILE);
        }
        PDFToolsConverterWSClient.initialize(servicePropertyFilePath);
        PDFToolsConverterWSClient.convert(inputFilePath, outputFilePath, xmpFilePath, converterOptions, byName, paramName, paramFile);
    }

    public static void initialize(String servicePropertyFilePath) throws IOException, FileNotFoundException {
        Properties serviceProperties;
        File servicePropertyFile;
        if (servicePropertyFilePath == null) {
            if (webService == null) {
                servicePropertyFilePath = ResourceUtil.getResource((String)DEFAULT_SERVICE_PROPERTY_FILEPATH).getAbsolutePath();
            } else {
                return;
            }
        }
        if ((servicePropertyFile = new File(servicePropertyFilePath)).exists() && servicePropertyFile.isFile() && servicePropertyFile.canRead()) {
            Logger.debug((Object)("loading configuration from: " + servicePropertyFilePath));
            serviceProperties = new Properties();
            try (FileInputStream inStream = new FileInputStream(servicePropertyFile);){
                serviceProperties.load(inStream);
            }
        } else {
            throw new IllegalArgumentException("cannot find WS properties at: " + servicePropertyFilePath);
        }
        PDFToolsConverterWSClient.getProperties(serviceProperties);
        PDFToolsConverterWSClient.initializeConverter();
    }

    private static void getProperties(Properties serviceProperties) {
        if (serviceProperties.containsKey(PROPERTY_SERVICE_URL)) {
            serviceProviderURL = serviceProperties.getProperty(PROPERTY_SERVICE_URL);
            Logger.debug((Object)("Setting service URL to: " + serviceProviderURL));
        }
        if (serviceProperties.containsKey(PROPERTY_SERVICE_CREDENTIALS_USERNAME)) {
            username = serviceProperties.getProperty(PROPERTY_SERVICE_CREDENTIALS_USERNAME);
            Logger.debug((Object)("Setting service user to: " + username));
        }
        if (serviceProperties.containsKey(PROPERTY_SERVICE_CREDENTIALS_PASSWORD)) {
            password = serviceProperties.getProperty(PROPERTY_SERVICE_CREDENTIALS_PASSWORD);
            Logger.debug((Object)"Setting service password to: XXX");
        }
        if (serviceProperties.containsKey(PROPERTY_SERVICE_TIMEOUT)) {
            String timeoutValue = serviceProperties.getProperty(PROPERTY_SERVICE_TIMEOUT);
            if (StringUtil.isNumeric((String)timeoutValue)) {
                timeout = Long.parseLong(timeoutValue);
                Logger.debug((Object)("Setting service timeout to: " + timeout));
            } else {
                Logger.warn((Object)String.format("Service timeout property (%s) is not numeric: %s", PROPERTY_SERVICE_TIMEOUT, timeoutValue));
            }
        }
        if (serviceProperties.containsKey(PROPERTY_SERVICE_MTOM)) {
            String mtomValue = serviceProperties.getProperty(PROPERTY_SERVICE_MTOM);
            if (null != mtomValue) {
                mtom = Boolean.parseBoolean(mtomValue);
                Logger.debug((Object)("Setting service mtom to: " + mtom));
            } else {
                Logger.warn((Object)String.format("Service mtom property (%s) is null!", PROPERTY_SERVICE_MTOM));
            }
        }
    }

    public static void convert(String inputFilePath, String outputFilePath, String xmpFilePath, String converterOptions, Boolean byName, String paramName, String paramFile) throws IOException, PDFToolsWSException {
        ConversionResult result;
        byte[] xmpData = PDFToolsConverterWSClient.getByteData(xmpFilePath);
        String name = new File(inputFilePath).getName();
        converterOptions = (String)converterOptions + ";ORIGINALNAME=" + name;
        if (byName.booleanValue()) {
            PDFToolsConverterWSClient.addSOAPActionHeader(webService, "http://pdf-tools.com/ws/o2p/ConvertFile2");
            result = webService.convertFile2(inputFilePath, (String)converterOptions, xmpData, outputFilePath);
        } else {
            result = PDFToolsConverterWSClient.sendFileToConverter(inputFilePath, (String)converterOptions, paramName, paramFile, xmpData);
            try (FileOutputStream file = new FileOutputStream(outputFilePath);
                 BufferedInputStream resultStream = new BufferedInputStream(result.getDocumentBytes().getInputStream());){
                resultStream.transferTo(file);
            }
        }
        if (result.getErrorCode() != 0) {
            String message = "conversion failed with errorCode: " + result.getErrorCode() + " and description: " + result.getErrorDescription();
            Logger.error((Object)message);
            throw new PDFToolsWSException(message);
        }
        int nPages = result.getNumPages();
        Logger.info((Object)(nPages + " pages converted at: " + outputFilePath));
    }

    private static ConversionResult sendFileToConverter(String inputFilePath, String converterOptions, String paramName, String paramFile, byte[] xmpData) throws IOException {
        byte[] inputDocBytes = PDFToolsConverterWSClient.getByteData(inputFilePath);
        byte[] paramData = PDFToolsConverterWSClient.getByteData(paramFile);
        if (paramName != null && paramData != null) {
            PDFToolsConverterWSClient.addSOAPActionHeader(webService, "http://pdf-tools.com/ws/o2p/ConvertFileWithData");
            return webService.convertFileWithData(inputDocBytes, converterOptions, xmpData, paramName, paramData);
        }
        PDFToolsConverterWSClient.addSOAPActionHeader(webService, "http://pdf-tools.com/ws/o2p/ConvertFile");
        return webService.convertFile(inputDocBytes, converterOptions, xmpData);
    }

    public static void convert(String inputFilePath, String outputFilePath) throws IOException, PDFToolsWSException {
        PDFToolsConverterWSClient.convert(inputFilePath, outputFilePath, null, "", Boolean.FALSE, null, null);
    }

    private static ConverterSoap initializeConverter() throws MalformedURLException {
        URL baseUrl = ResourceUtil.getResourceURL((String)".");
        String wsdlURLString = "http://localhost/wsdl/PDFToolsConverter.wsdl";
        URL wsdlLocation = new URL(baseUrl, "http://localhost/wsdl/PDFToolsConverter.wsdl");
        QName serviceName = new QName("http://pdf-tools.com/ws/o2p/", "Converter");
        Converter converter = new Converter(wsdlLocation, serviceName);
        webService = converter.getConverterSoap12();
        ((BindingProvider)webService).getRequestContext().put("javax.xml.ws.service.endpoint.address", serviceProviderURL);
        PDFToolsConverterWSClient.setMTOM(webService);
        PDFToolsConverterWSClient.setTimeout(webService);
        PDFToolsConverterWSClient.setCredentials(webService);
        return webService;
    }

    private static void setMTOM(ConverterSoap ws) {
        BindingProvider provider = (BindingProvider)ws;
        SOAPBinding sopadBinding = (SOAPBinding)provider.getBinding();
        sopadBinding.setMTOMEnabled(mtom);
        Logger.debug((Object)("Setting MTOM on SOAP binding to: " + mtom));
    }

    private static void setTimeout(ConverterSoap ws) {
        BindingProvider provider = (BindingProvider)ws;
        Client client = ClientProxy.getClient((Object)provider);
        HTTPConduit http = (HTTPConduit)client.getConduit();
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setConnectionTimeout(timeout);
        httpClientPolicy.setReceiveTimeout(timeout);
        http.setClient(httpClientPolicy);
    }

    private static void setCredentials(ConverterSoap ws) {
        if (username == null || password == null) {
            Logger.info((Object)"No credentials provided");
            return;
        }
        BindingProvider provider = (BindingProvider)ws;
        provider.getRequestContext().put("javax.xml.ws.security.auth.username", username);
        provider.getRequestContext().put("javax.xml.ws.security.auth.password", password);
    }

    private static void addSOAPActionHeader(ConverterSoap ws, String value) {
        BindingProvider provider = (BindingProvider)ws;
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("SOAPAction", Arrays.asList(value));
        provider.getRequestContext().put(Message.PROTOCOL_HEADERS, headers);
    }

    private static byte[] getByteData(String pathName) throws IOException {
        byte[] byteArray = null;
        if (pathName != null) {
            byteArray = Files.readAllBytes(Paths.get(pathName, new String[0]));
        }
        return byteArray;
    }

    protected static void parseOptions(String[] args, Class className) {
        try {
            Logger.debug((Object)("Parsing arguments: " + Arrays.toString(args)));
            options = parser.parse(args);
        }
        catch (OptionException e) {
            Logger.error((Object)"incorrect options");
            PDFToolsConverterWSClient.printOptions(className);
            throw e;
        }
    }

    protected static void printOptions(Class className) {
        String usage = "Usage: java " + className.getName() + "\nParameters:\n";
        try (StringWriter writer = new StringWriter();){
            parser.printHelpOn((Writer)writer);
            usage = usage + writer.toString();
        }
        catch (IOException e) {
            Logger.error((Object)"Error showing print usage");
        }
        Logger.info((Object)usage);
    }

    static {
        timeout = 60000L;
        mtom = false;
    }
}

