/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces;

public enum ResourceType {
    FOLDER("Folder", "Resource type is a folder", true),
    CONTAINER("Container", "Resource is a container.", true),
    FILE("File", "Resource type is a file.", false);

    private boolean allowsChildren;
    private String resourceType;
    private String resourceTypeDescription;

    private ResourceType(String resourceType, String resourceTypeDescription, boolean allowsChildren) {
        this.resourceType = resourceType;
        this.resourceTypeDescription = resourceTypeDescription;
        this.allowsChildren = allowsChildren;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceTypeDescription() {
        return this.resourceTypeDescription;
    }

    public boolean allowsChildren() {
        return this.allowsChildren;
    }

    public static ResourceType getResourceTypeForOrdinal(int value) {
        ResourceType resourceType = null;
        switch (value) {
            case 0: {
                resourceType = FOLDER;
                break;
            }
            case 1: {
                resourceType = CONTAINER;
                break;
            }
            case 2: {
                resourceType = FILE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid resource type " + value + "!");
            }
        }
        return resourceType;
    }
}

