/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.properties;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicHeader;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.common.util.Base64;
import org.apache.solr.common.util.NamedList;

public class AuthHttpSolrClient
extends HttpSolrClient {
    private static final String UTF_8 = StandardCharsets.UTF_8.name();
    private String userName;
    private String password;

    public AuthHttpSolrClient(String baseURL, String userName, String password) {
        super(baseURL);
        this.userName = userName;
        this.password = password;
    }

    public NamedList<Object> request(SolrRequest request, String collection) throws SolrServerException, IOException {
        ResponseParser responseParser = request.getResponseParser();
        if (responseParser == null) {
            responseParser = this.parser;
        }
        return this.request(request, responseParser, collection);
    }

    public NamedList<Object> request(SolrRequest request, ResponseParser processor, String collection) throws SolrServerException, IOException {
        HttpRequestBase method = this.createMethod(request, collection);
        String userPass = this.userName + ":" + this.password;
        String encoded = Base64.byteArrayToBase64((byte[])userPass.getBytes(UTF_8));
        method.setHeader((Header)new BasicHeader("Authorization", "Basic " + encoded));
        return this.executeMethod(method, processor);
    }
}

