/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.security;

import com.exlibris.core.infra.svc.api.utils.AuthenticationUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class BasicAuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    protected String obtainUsername(HttpServletRequest request) {
        return ":BasicAuthentication:";
    }

    protected String obtainPassword(HttpServletRequest request) {
        return request.getHeader("Authorization");
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        return StringUtils.isNotBlank((String)request.getHeader("Authorization"));
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        this.setPostOnly(false);
        return super.attemptAuthentication(request, response);
    }

    protected void setDetails(HttpServletRequest request, UsernamePasswordAuthenticationToken authRequest) {
        HashMap<String, Map<String, String>> parameters = new HashMap<String, Map<String, String>>();
        parameters.put("authenticationParameters", AuthenticationUtil.getAuthenticationParameters(request));
        authRequest.setDetails(parameters);
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        SecurityContextHolder.getContext().setAuthentication(authResult);
        request = new HttpServletRequestWrapper((HttpServletRequest)request){
            private Set<String> headerNameSet;

            public Enumeration<String> getHeaderNames() {
                if (this.headerNameSet == null) {
                    this.headerNameSet = new HashSet<String>();
                    Enumeration wrappedHeaderNames = super.getHeaderNames();
                    while (wrappedHeaderNames.hasMoreElements()) {
                        String headerName = (String)wrappedHeaderNames.nextElement();
                        if ("Authorization".equalsIgnoreCase(headerName)) continue;
                        this.headerNameSet.add(headerName);
                    }
                }
                return Collections.enumeration(this.headerNameSet);
            }

            public Enumeration<String> getHeaders(String name) {
                if ("Authorization".equalsIgnoreCase(name)) {
                    return Collections.emptyEnumeration();
                }
                return super.getHeaders(name);
            }

            public String getHeader(String name) {
                if ("Authorization".equalsIgnoreCase(name)) {
                    return null;
                }
                return super.getHeader(name);
            }
        };
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

