/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.utils;

import com.exlibris.core.infra.Common;
import com.exlibris.core.infra.common.exceptions.InfraException;
import com.exlibris.core.infra.common.exceptions.logging.Descriptor;
import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.security.UserPrincipalRetriever;
import com.exlibris.core.infra.model.HFrUser;
import com.exlibris.core.infra.model.HFrUserRoles;
import com.exlibris.core.infra.model.consortium.HFrInstitution;
import com.exlibris.core.infra.svc.api.AuthenticationManager;
import com.exlibris.core.infra.svc.api.ConsortiumManager;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.UserManager;
import com.exlibris.core.infra.svc.api.config.PrivilegeCacheManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.utils.UserData;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.impl.util.Base64;

public class AuthenticationUtil {
    private static final ExLogger log = ExLogger.getExLogger(AuthenticationUtil.class);
    private static final String DEPOSIT = "/deposit";
    private static final String DELIVERY = "/delivery";

    public static UserData getUserData(String username, String password, String inst, Boolean ignoreAuthValidate) {
        return AuthenticationUtil.getUserData(username, password, inst, ignoreAuthValidate, false);
    }

    public static UserData getUserData(String username, String password, String inst, Boolean ignoreAuthValidate, boolean allowConsortiumLevel) {
        List<HFrUserRoles> userRoles;
        String institutionPath;
        UserData userData = new UserData();
        AuthenticationManager pdManager = (AuthenticationManager)ServiceLocator.getInstance().lookUp(AuthenticationManager.class);
        ConsortiumManager consMng = (ConsortiumManager)ServiceLocator.getInstance().lookUp(ConsortiumManager.class);
        HFrInstitution institution = consMng.findInstitutionByCode(inst);
        String string = institutionPath = institution != null ? institution.getPath() : null;
        if ("CRS00".equals(inst) && allowConsortiumLevel) {
            institutionPath = "CRS00";
        }
        if (!(ignoreAuthValidate.booleanValue() || pdManager.ValidateLocalAccess(username, password) && institutionPath != null)) {
            userData.setValidLocalAuthentication(false);
            return userData;
        }
        userData.setValidLocalAuthentication(true);
        HFrUser user = null;
        String userIdStr = null;
        try {
            UserManager depMng = (UserManager)ServiceLocator.getInstance().lookUp(UserManager.class);
            user = depMng.getUserByName(username);
            userIdStr = user.getId().toString();
        }
        catch (Exception e) {
            Descriptor descriptor = new Descriptor(DescriptorConstants.DP_InvalidUserOrInstitution.getId());
            descriptor.setMessage(DescriptorConstants.DP_InvalidUserOrInstitution.getDetailedMessage(userIdStr, inst));
            userData.setValidLocalAuthentication(false);
            userData.setDescriptor(descriptor);
            return userData;
        }
        userData.setInstitution(institution);
        userData.setUser(user);
        try {
            userRoles = pdManager.getUserRoleByUserAndInstitution(user, institutionPath);
        }
        catch (InfraException e) {
            log.error("Unable to get user roles for userName: " + user.getUserName(), new String[0]);
            return userData;
        }
        HashSet<String> privileges = new HashSet<String>();
        for (HFrUserRoles role : userRoles) {
            if (!role.getStatus().equals((Object)HFrUserRoles.Status.ACTIVE)) continue;
            String userRoleName = Integer.toString(role.getRoleType());
            privileges.addAll(PrivilegeCacheManager.getInstance().getPrivileges2Role(userRoleName));
        }
        userData.setPrivileges(privileges);
        return userData;
    }

    public static void parseHeaderString(Map<String, Object> httpHeaders, Map<String, String> params) throws Exception {
        String basicAuth = null;
        try {
            basicAuth = httpHeaders.get("Authorization").toString().replace("[", "").replace("]", "");
            if (basicAuth == null) {
                throw new Exception("Invalid header");
            }
            basicAuth = new String(Base64.decode((byte[])basicAuth.split(" ")[1].getBytes()));
        }
        catch (Exception e) {
            throw new Exception("There was a problem decoding the header string: " + basicAuth);
        }
        params.put("username", basicAuth.split("-institutionCode-")[0]);
        params.put("password", basicAuth.split(":", 2)[1]);
        params.put("inst", basicAuth.split("-institutionCode-")[1].split(":")[0]);
    }

    public static void setAuthenticationAttributes(HttpServletRequest request) {
        if (UserPrincipalRetriever.getUserPrincipal() == null) {
            AuthenticationManager authenticationManager = (AuthenticationManager)ServiceLocator.getInstance().lookUp(AuthenticationManager.class);
            authenticationManager.setSessionAuthenticationAttributes(request);
        }
    }

    public static boolean isValidHeader(Map<String, Object> httpHeaders) {
        String basicAuth = null;
        try {
            basicAuth = httpHeaders.get("Authorization").toString().replace("[", "").replace("]", "");
            if (basicAuth == null) {
                return false;
            }
            basicAuth = new String(Base64.decode((byte[])basicAuth.split(" ")[1].getBytes()));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static UserData getUserDataByHeader(String basicAuth) {
        basicAuth = new String(Base64.decode((byte[])basicAuth.split(" ")[1].getBytes()));
        String user = basicAuth.split("-institutionCode-")[0];
        String pass = basicAuth.split(":")[1];
        String inst = basicAuth.split("-institutionCode-")[1].split(":")[0];
        return AuthenticationUtil.getUserData(user, pass, inst, false, true);
    }

    public static Map<String, String> getAuthenticationParameters(HttpServletRequest request) {
        Map authenticationParameters = null;
        if (UserPrincipalRetriever.getUserPrincipal() != null) {
            authenticationParameters = UserPrincipalRetriever.getUserPrincipal().getAuthenticationParameters();
        }
        if (authenticationParameters == null) {
            authenticationParameters = (Map)request.getSession().getAttribute("authenticationParameters");
        }
        return authenticationParameters;
    }

    public static String getAuthenticationProfileName(HttpServletRequest request) {
        Map<String, String> authenticationParameters = AuthenticationUtil.getAuthenticationParameters(request);
        return authenticationParameters != null ? authenticationParameters.get("authenticationProfile") : null;
    }

    public static void saveRelayStateOnSession(HttpServletRequest request) {
        if (StringUtils.isNotBlank((String)request.getParameter("RelayState"))) {
            AuthenticationUtil.saveRelayStateOnSession(request, request.getParameter("RelayState"));
        }
    }

    public static void saveRelayStateOnSession(HttpServletRequest request, String url) {
        request.getSession().setAttribute("RelayState", (Object)url);
    }

    public static String getRelayStateFromSession(HttpServletRequest request) {
        return (String)request.getSession().getAttribute("RelayState");
    }

    public static String getAuthenticationModeName(HttpServletRequest request) {
        AuthenticationManager authenticationManager = (AuthenticationManager)ServiceLocator.getInstance().lookUp(AuthenticationManager.class);
        Common.AuthenticationMode authenticationMode = authenticationManager.getAuthenticationMode(request);
        String authenticationModeName = authenticationMode.name();
        if (!Common.AuthenticationMode.LOCAL.equals((Object)authenticationMode) && !Common.AuthenticationMode.PDS.equals((Object)authenticationMode)) {
            authenticationModeName = AuthenticationUtil.getAuthenticationProfileName(request);
        }
        return authenticationModeName;
    }

    public static String getUserIp(HttpServletRequest request) {
        String ip = request.getRemoteAddr();
        GeneralParameterManager generalParameterManager = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
        String headerParam = generalParameterManager.getParameter("delivery", "client_ip_header");
        if (headerParam != null && !headerParam.isEmpty()) {
            ip = request.getHeader(headerParam);
            if (ip != null) {
                if (!AuthenticationUtil.validateAnIpAddressWithRegularExpression(ip)) {
                    ip = request.getRemoteAddr();
                }
            } else {
                ip = request.getRemoteAddr();
            }
        }
        return ip;
    }

    private static boolean validateAnIpAddressWithRegularExpression(String iPaddress) {
        Pattern IP_PATTERN = Pattern.compile("\\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b");
        return IP_PATTERN.matcher(iPaddress).matches();
    }

    public static String getServerUrl(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        String serverUrl = DEPOSIT.equalsIgnoreCase(contextPath) ? AuthenticationUtil.getDepositUrl() : (DELIVERY.equalsIgnoreCase(contextPath) ? AuthenticationUtil.getDeliveryUrl() + contextPath : AuthenticationUtil.getBackofficeUrl() + contextPath);
        return URI.create(serverUrl).normalize().toString();
    }

    public static String getBackofficeUrl() {
        return AuthenticationUtil.getGeneralParameterManager().getParameter("repository", "repository_server");
    }

    public static String getDeliveryUrl() {
        return AuthenticationUtil.getGeneralParameterManager().getParameter("delivery", "delivery_server");
    }

    public static String getDepositUrl() {
        return AuthenticationUtil.getGeneralParameterManager().getParameter("deposit", "url");
    }

    private static GeneralParameterManager getGeneralParameterManager() {
        return (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
    }
}

