/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.storage.handler;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.locator.PluginLocator;
import com.exlibris.core.sdk.storage.containers.StoredEntityMetaData;
import com.exlibris.core.sdk.storage.handler.StorageHandler;
import com.exlibris.core.sdk.storage.handler.StorageUtil;
import com.exlibris.digitool.common.storage.Fixity;
import com.exlibris.digitool.exceptions.DigitoolException;
import com.exlibris.dps.repository.plugin.CustomFixityPlugin;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractStorageHandler
implements StorageHandler {
    private static final String ID_SEPERATOR = "-";
    private static final String EXSTENTION_PREFIX = ".";
    private static final String VERSION_PREFIX = "V";
    private static final ExLogger log = ExLogger.getExLogger(AbstractStorageHandler.class);
    protected Map<String, String> parameters = null;
    protected Long storageId;
    protected Long storageGroupId;
    private GeneralParameterManager generalParameterManager;

    @Override
    public void init(Map<String, String> params) {
        this.parameters = params;
    }

    protected String createFileName(StoredEntityMetaData storedEntityMetadata) {
        String entId = storedEntityMetadata.getEntityPid();
        String fileExt = storedEntityMetadata.getFileExstention();
        if (!StoredEntityMetaData.EntityType.FILE.equals((Object)storedEntityMetadata.getEntityType()) && StringUtils.isBlank((String)fileExt)) {
            fileExt = "xml";
        }
        int version = storedEntityMetadata.getVersion() == null ? 1 : storedEntityMetadata.getVersion();
        String newName = VERSION_PREFIX + version + ID_SEPERATOR + entId + (StringUtils.isBlank((String)fileExt) ? "" : EXSTENTION_PREFIX + fileExt);
        return newName;
    }

    @Override
    public void setStorageId(Long storageId) {
        this.storageId = storageId;
    }

    @Override
    public void setStorageGroupId(Long storageGroupId) {
        this.storageGroupId = storageGroupId;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Override
    public Long getStorageId() {
        return this.storageId;
    }

    @Override
    public Long getStorageGroupId() {
        return this.storageGroupId;
    }

    protected void updateObjectDnx(StoredEntityMetaData storedEntityMetadata, Fixity fixity) throws DigitoolException {
        if (storedEntityMetadata == null || fixity == null) {
            return;
        }
        switch (storedEntityMetadata.getEntityType()) {
            case FILE: {
                storedEntityMetadata.getFileDnx().setFileFixity("Storage", fixity.getAlgorithm(), fixity.getValue());
            }
        }
    }

    protected String getTempStorageDirectory() {
        return this.getTempStorageDirectory(true);
    }

    protected String getTempStorageDirectory(boolean includeStorageId) {
        return StorageUtil.getTempStorageDirectory() + (includeStorageId ? this.getStorageId() + File.separator : "");
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    protected String getChecksumUsingPlugin(String filePath, String pluginName, String oldFixityValue) throws Exception {
        CustomFixityPlugin plugin = (CustomFixityPlugin)PluginLocator.getInstance().lookUp(CustomFixityPlugin.class, pluginName);
        String fixity = plugin.getFixity(filePath, oldFixityValue);
        List<String> errors = plugin.getErrors();
        if (errors != null) {
            for (String error : errors) {
                log.warn((Object)error, new String[0]);
            }
        }
        return fixity;
    }
}

