/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class FixedLengthInputStream
extends FilterInputStream {
    protected long remaining;

    public FixedLengthInputStream(InputStream in, long length) {
        super(in);
        this.remaining = length;
    }

    @Override
    public void close() throws IOException {
        long skippedLast = 0L;
        if (this.remaining > 0L) {
            skippedLast = this.skip(this.remaining);
            while (this.remaining > 0L && skippedLast > 0L) {
                skippedLast = this.skip(this.remaining);
            }
        }
    }

    @Override
    public int available() throws IOException {
        return this.remaining > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.remaining;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read() throws IOException {
        int b = -1;
        if (this.remaining > 0L && (b = this.in.read()) != -1) {
            --this.remaining;
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = -1;
        if (this.remaining > 0L && (bytesRead = this.in.read(b, off, (int)Math.min((long)len, this.remaining))) > 0) {
            this.remaining -= (long)bytesRead;
        }
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long bytesSkipped = 0L;
        if (this.remaining > 0L) {
            bytesSkipped = this.in.skip(Math.min(n, this.remaining));
            this.remaining -= bytesSkipped;
        }
        return bytesSkipped;
    }
}

