/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.automata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.byteseek.automata.State;
import net.byteseek.automata.Transition;
import net.byteseek.utils.ArgUtils;
import net.byteseek.utils.collections.IdentityHashSet;
import net.byteseek.utils.factory.DeepCopy;

public class MutableState<T>
implements State<T> {
    private List<Transition<T>> transitions;
    private List<T> associations;
    private boolean isFinal;
    private Boolean isDeterministic;

    public MutableState() {
        this(false);
    }

    public MutableState(boolean isFinal) {
        this.isFinal = isFinal;
        this.transitions = Collections.emptyList();
        this.associations = Collections.emptyList();
    }

    public MutableState(State<T> other) {
        ArgUtils.checkNullObject(other, "other");
        this.isFinal = other.isFinal();
        List<Transition<T>> otherTransitions = other.getTransitions();
        this.transitions = otherTransitions != null && otherTransitions.size() > 0 ? new ArrayList<Transition<T>>(otherTransitions) : Collections.emptyList();
        Collection<T> otherAssoc = other.getAssociations();
        this.associations = otherAssoc != null ? new ArrayList<T>(otherAssoc) : Collections.emptyList();
    }

    @Override
    public final Iterator<Transition<T>> iterator() {
        return new TransitionIterator();
    }

    @Override
    public final List<Transition<T>> getTransitions() {
        if (this.transitions.isEmpty()) {
            return this.transitions;
        }
        return new ArrayList<Transition<T>>(this.transitions);
    }

    @Override
    public final void addTransition(Transition<T> transition) {
        if (this.transitions.isEmpty()) {
            this.transitions = new ArrayList<Transition<T>>(1);
        }
        this.transitions.add(transition);
        this.isDeterministic = null;
    }

    @Override
    public final void addAllTransitions(List<Transition<T>> transitionList) {
        if (this.transitions.isEmpty()) {
            this.transitions = new ArrayList<Transition<T>>(transitionList.size());
        }
        this.transitions.addAll(transitionList);
        this.isDeterministic = null;
    }

    @Override
    public final void addAllTransitions(Iterator<Transition<T>> transitionIterator) {
        if (this.transitions.isEmpty()) {
            this.transitions = new ArrayList<Transition<T>>(3);
        }
        while (transitionIterator.hasNext()) {
            this.transitions.add(transitionIterator.next());
        }
        this.isDeterministic = null;
    }

    @Override
    public final boolean removeTransition(Transition<T> transition) {
        if (!this.transitions.isEmpty()) {
            boolean wasRemoved = this.transitions.remove(transition);
            if (this.transitions.isEmpty()) {
                this.transitions = Collections.emptyList();
            }
            this.isDeterministic = null;
            return wasRemoved;
        }
        return false;
    }

    @Override
    public final boolean replaceTransition(Transition<T> oldTransition, Transition<T> newTransition) {
        boolean wasRemoved;
        if (!this.transitions.isEmpty() && (wasRemoved = this.transitions.remove(oldTransition))) {
            this.transitions.add(newTransition);
            this.isDeterministic = null;
            return true;
        }
        return false;
    }

    @Override
    public void clearTransitions() {
        this.transitions = Collections.emptyList();
        this.isDeterministic = null;
    }

    @Override
    public final void appendNextStates(Collection<State<T>> states, byte value) {
        IdentityHashSet matchingStates = new IdentityHashSet();
        for (Transition<T> transition : this.transitions) {
            State<T> nextState = transition.getStateForByte(value);
            if (nextState == null || matchingStates.contains(nextState)) continue;
            matchingStates.add(nextState);
            states.add(nextState);
        }
    }

    @Override
    public final State<T> getNextState(byte value) {
        for (Transition<T> transition : this.transitions) {
            State<T> nextState = transition.getStateForByte(value);
            if (nextState == null) continue;
            return nextState;
        }
        return null;
    }

    @Override
    public final boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public boolean isDeterministic() {
        if (this.transitions.size() > 1) {
            if (this.isDeterministic == null) {
                HashMap<Byte, State<T>> bytesToStates = new HashMap<Byte, State<T>>(128);
                for (Transition<T> transition : this.transitions) {
                    byte[] matchingBytes = transition.getBytes();
                    State<T> toState = transition.getToState();
                    for (byte b : matchingBytes) {
                        State existingState = (State)bytesToStates.get(b);
                        if (existingState == toState) continue;
                        if (existingState != null) {
                            this.isDeterministic = Boolean.FALSE;
                            return false;
                        }
                        bytesToStates.put(b, toState);
                    }
                }
                this.isDeterministic = Boolean.TRUE;
            }
            return this.isDeterministic;
        }
        return true;
    }

    public final void invalidateDeterministicStatus() {
        this.isDeterministic = null;
    }

    @Override
    public final void setIsFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    @Override
    public Collection<T> getAssociations() {
        if (this.associations.isEmpty()) {
            return this.associations;
        }
        return new ArrayList<T>(this.associations);
    }

    @Override
    public Iterator<T> associationIterator() {
        return this.associations.iterator();
    }

    @Override
    public void addAssociation(T association) {
        if (this.associations.isEmpty()) {
            this.associations = new ArrayList<T>(1);
        }
        this.associations.add(association);
    }

    @Override
    public void addAllAssociations(Collection<? extends T> associationsToAdd) {
        if (this.associations.isEmpty()) {
            this.associations = new ArrayList<T>(associationsToAdd.size());
        }
        this.associations.addAll(associationsToAdd);
    }

    @Override
    public void addAllAssociations(Iterator<T> associationIterator) {
        if (this.associations.isEmpty()) {
            this.associations = new ArrayList<T>(2);
        }
        while (associationIterator.hasNext()) {
            this.associations.add(associationIterator.next());
        }
    }

    @Override
    public boolean removeAssociation(Object association) {
        boolean wasRemoved = this.associations.remove(association);
        if (this.associations.isEmpty()) {
            this.associations = Collections.emptyList();
        }
        return wasRemoved;
    }

    @Override
    public void setAssociations(Collection<? extends T> associations) {
        if (this.associations.isEmpty()) {
            this.associations = new ArrayList<T>(associations.size());
        }
        this.associations.addAll(associations);
    }

    @Override
    public void clearAssociations() {
        this.associations = Collections.emptyList();
    }

    @Override
    public MutableState<T> deepCopy() {
        return this.deepCopy((Map)new IdentityHashMap());
    }

    @Override
    public MutableState<T> deepCopy(Map<DeepCopy, DeepCopy> oldToNewObjects) {
        MutableState<T> stateCopy = (MutableState<T>)oldToNewObjects.get(this);
        if (stateCopy == null) {
            stateCopy = new MutableState<T>(this.isFinal);
            oldToNewObjects.put(this, stateCopy);
            for (Transition<T> transition : this.transitions) {
                Transition<T> transitionCopy = transition.deepCopy(oldToNewObjects);
                stateCopy.transitions.add(transitionCopy);
            }
        }
        return stateCopy;
    }

    private final class TransitionIterator
    implements Iterator<Transition<T>> {
        private int index;
        private boolean removed;

        private TransitionIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < MutableState.this.transitions.size();
        }

        @Override
        public Transition<T> next() {
            this.removed = false;
            if (this.hasNext()) {
                return (Transition)MutableState.this.transitions.get(this.index++);
            }
            throw new NoSuchElementException("There are no more transitions in the state.");
        }

        @Override
        public void remove() {
            int elementToRemove = this.index - 1;
            if (elementToRemove >= 0 && !this.removed) {
                MutableState.this.removeTransition((Transition)MutableState.this.transitions.get(elementToRemove));
                this.removed = true;
            }
            throw new IllegalStateException("Next has not been called or remove has already been called.");
        }
    }
}

