/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.dnx;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.digitool.common.dnx.DnxDocument;
import com.exlibris.digitool.common.dnx.DnxSectionRecord;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class DnxSection {
    private final Element section;
    private final DnxDocument parent;
    private final List<DnxSectionRecord> recordList = new ArrayList<DnxSectionRecord>();
    ExLogger logger = ExLogger.getExLogger(DnxSection.class);

    DnxSection(DnxDocument dnxDocument, Element section) {
        this.section = section;
        this.parent = dnxDocument;
    }

    public void removeRecord(int recordIndex) {
        if (recordIndex < 0 || recordIndex >= this.recordList.size()) {
            return;
        }
        DnxSectionRecord record = this.recordList.get(recordIndex);
        this.section.remove(record.getElement());
        this.recordList.remove(recordIndex);
    }

    public void removeRecord(DnxSectionRecord record) {
        this.section.remove(record.getElement());
        this.recordList.remove(record);
    }

    public String getId() {
        return this.section.attributeValue(DnxDocument.ID);
    }

    public DnxSectionRecord createRecord() {
        Element record = this.section.addElement(DnxDocument.RECORD);
        DnxSectionRecord dnxSectionRecord = new DnxSectionRecord(this, record);
        this.recordList.add(dnxSectionRecord);
        return dnxSectionRecord;
    }

    public DnxDocument getParent() {
        return this.parent;
    }

    public List<DnxSectionRecord> getRecordList() {
        return this.recordList;
    }

    public void updateSectionKey(String keyId, String value) {
        if (this.getRecordList().size() == 0) {
            this.createRecord();
        }
        if (this.getRecordList().size() > 1) {
            this.logger.warn((Object)("more than one record exist for section " + this.getId()), new String[0]);
        }
        DnxSectionRecord record = this.getRecordList().get(0);
        record.updateKey(keyId, value);
    }

    public String getSectionKeyValue(String sectionKeyId) {
        DnxSectionRecord record = null;
        if (this.getRecordList().size() == 0) {
            return null;
        }
        if (this.getRecordList().size() > 1) {
            this.logger.warn((Object)("more than one record exist for section " + this.getId()), new String[0]);
        }
        record = this.getRecordList().get(0);
        return record.getSectionKeyValue(sectionKeyId);
    }

    Element getElement() {
        return this.section;
    }
}

