/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.math.BigInteger;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUnsignedInt;

public class XSUnsignedShort
extends XSUnsignedInt {
    private static final String XS_UNSIGNED_SHORT = "xs:unsignedShort";

    public XSUnsignedShort() {
        this(BigInteger.valueOf(0L));
    }

    public XSUnsignedShort(BigInteger x) {
        super(x);
    }

    public String string_type() {
        return XS_UNSIGNED_SHORT;
    }

    public String type_name() {
        return "unsignedShort";
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyType aat = arg.first();
        try {
            BigInteger bigInt = new BigInteger(aat.string_value());
            BigInteger min = BigInteger.valueOf(0L);
            BigInteger max = BigInteger.valueOf(65535L);
            if (bigInt.compareTo(min) < 0 || bigInt.compareTo(max) > 0) {
                throw DynamicError.cant_cast(null);
            }
            rs.add(new XSUnsignedShort(bigInt));
            return rs;
        }
        catch (NumberFormatException e) {
            throw DynamicError.cant_cast(null);
        }
    }
}

