/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ContentType {
    protected static final int S_START = 0;
    protected static final int S_CONTENTTYPE = 1;
    protected static final int S_MEDIATYPE = 2;
    protected static final int S_MEDIATYPE_WHITESPACE = 3;
    protected static final int S_SEMICOLON = 4;
    protected static final int S_PARAM_NAME = 5;
    protected static final int S_PARAM_EQ = 6;
    protected static final int S_PARAM_VALUE = 7;
    protected static final int S_PARAM_QUOTED_VALUE = 8;
    protected static final int S_PARAM_QUOTED_PAIR = 9;
    protected static final int S_PARAM_VALUE_WHITESPACE = 10;
    protected static final int CC_CONTROL = 1;
    protected static final int CC_SEPARATOR_WS = 2;
    public String contentType;
    public String mediaType;
    public Map<String, String> parameters;
    protected static final String separators = "()<>@,;:\\\"/[]?={} \t";
    protected static final byte[] charCharacteristicsTab;

    public static boolean isTokenCharacter(int c) {
        return c >= 0 && c < 256 && charCharacteristicsTab[c] == 0 || c >= 256;
    }

    public static ContentType parseContentType(String contentTypeStr) {
        if (contentTypeStr == null || contentTypeStr.length() == 0) {
            return null;
        }
        ContentType ct = new ContentType();
        StringBuffer nameSb = new StringBuffer();
        StringBuffer valueSb = null;
        int state = 0;
        int idx = 0;
        boolean bLoop = true;
        while (bLoop) {
            int c;
            if (idx < contentTypeStr.length()) {
                c = contentTypeStr.charAt(idx);
            } else {
                c = -1;
                bLoop = false;
            }
            switch (state) {
                case 0: {
                    if (c == 32 || c == 9) {
                        ++idx;
                        break;
                    }
                    if (ContentType.isTokenCharacter(c)) {
                        nameSb.setLength(0);
                        nameSb.append((char)c);
                        ++idx;
                        state = 1;
                        break;
                    }
                    return null;
                }
                case 1: {
                    if (ContentType.isTokenCharacter(c)) {
                        nameSb.append((char)c);
                        ++idx;
                        break;
                    }
                    if (c == 47) {
                        ct.contentType = nameSb.toString().toLowerCase();
                        ++idx;
                        nameSb.setLength(0);
                        state = 2;
                        break;
                    }
                    return null;
                }
                case 2: {
                    if (ContentType.isTokenCharacter(c)) {
                        nameSb.append((char)c);
                        ++idx;
                        break;
                    }
                    if (c == -1) {
                        if (nameSb.length() == 0) {
                            return null;
                        }
                        ct.mediaType = nameSb.toString().toLowerCase();
                        break;
                    }
                    if (c == 59) {
                        if (nameSb.length() == 0) {
                            return null;
                        }
                        ct.mediaType = nameSb.toString().toLowerCase();
                        ++idx;
                        valueSb = new StringBuffer();
                        ct.parameters = new HashMap<String, String>();
                        state = 4;
                        break;
                    }
                    if (c == 32 || c == 9) {
                        if (nameSb.length() == 0) {
                            return null;
                        }
                        ct.mediaType = nameSb.toString().toLowerCase();
                        ++idx;
                        state = 3;
                        break;
                    }
                    return null;
                }
                case 3: {
                    if (c == 32 || c == 9) {
                        ++idx;
                        break;
                    }
                    if (c == -1) break;
                    return null;
                }
                case 4: {
                    if (c == 32 || c == 9) {
                        ++idx;
                        break;
                    }
                    if (ContentType.isTokenCharacter(c)) {
                        nameSb.setLength(0);
                        valueSb.setLength(0);
                        nameSb.append((char)c);
                        ++idx;
                        state = 5;
                        break;
                    }
                    if (c == -1) break;
                    return null;
                }
                case 5: {
                    if (ContentType.isTokenCharacter(c)) {
                        nameSb.append((char)c);
                        ++idx;
                        break;
                    }
                    if (c == 61) {
                        ++idx;
                        state = 6;
                        break;
                    }
                    return null;
                }
                case 6: {
                    if (ContentType.isTokenCharacter(c)) {
                        valueSb.append((char)c);
                        ++idx;
                        state = 7;
                        break;
                    }
                    if (c == 34) {
                        ++idx;
                        state = 8;
                        break;
                    }
                    return null;
                }
                case 7: {
                    if (ContentType.isTokenCharacter(c)) {
                        valueSb.append((char)c);
                        ++idx;
                        break;
                    }
                    if (c == -1) {
                        ct.parameters.put(nameSb.toString().toLowerCase(), valueSb.toString());
                        break;
                    }
                    if (c == 59) {
                        ct.parameters.put(nameSb.toString().toLowerCase(), valueSb.toString());
                        ++idx;
                        state = 4;
                        break;
                    }
                    if (c == 32 || c == 9) {
                        ct.parameters.put(nameSb.toString().toLowerCase(), valueSb.toString());
                        ++idx;
                        state = 10;
                        break;
                    }
                    return null;
                }
                case 8: {
                    if (c == 34) {
                        ct.parameters.put(nameSb.toString().toLowerCase(), valueSb.toString());
                        ++idx;
                        state = 10;
                        break;
                    }
                    if (c == 92) {
                        ++idx;
                        state = 9;
                        break;
                    }
                    if (c != -1) {
                        valueSb.append((char)c);
                        ++idx;
                        break;
                    }
                    return null;
                }
                case 9: {
                    if (c != -1) {
                        valueSb.append((char)c);
                        ++idx;
                        state = 8;
                        break;
                    }
                    return null;
                }
                case 10: {
                    if (c == 32 || c == 9) {
                        ++idx;
                        break;
                    }
                    if (c == 59) {
                        ++idx;
                        state = 4;
                        break;
                    }
                    if (c == -1) break;
                    return null;
                }
            }
        }
        return ct;
    }

    public String getParameter(String name) {
        if (name == null || name.length() == 0 || this.parameters == null) {
            return null;
        }
        return this.parameters.get(name.toLowerCase());
    }

    public void setParameter(String name, String value) {
        if (name != null && name.length() > 0 && value != null) {
            if (this.parameters == null) {
                this.parameters = new HashMap<String, String>();
            }
            this.parameters.put(name.toLowerCase(), value);
        }
    }

    public static boolean quote(String str) {
        boolean quote = false;
        if (str != null && str.length() > 0) {
            int idx = 0;
            while (idx < str.length() && !quote) {
                char c;
                if ((c = str.charAt(idx++)) >= '\u0100' || (charCharacteristicsTab[c] & 2) == 0) continue;
                quote = true;
            }
        }
        return quote;
    }

    public String toStringShort() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.contentType);
        sb.append('/');
        sb.append(this.mediaType);
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.contentType);
        sb.append('/');
        sb.append(this.mediaType);
        if (this.parameters != null) {
            Iterator<Map.Entry<String, String>> iter = this.parameters.entrySet().iterator();
            while (iter.hasNext()) {
                sb.append("; ");
                Map.Entry<String, String> entry = iter.next();
                sb.append(entry.getKey());
                sb.append('=');
                if (ContentType.quote(entry.getValue())) {
                    sb.append('\"');
                    sb.append(entry.getValue());
                    sb.append('\"');
                    continue;
                }
                sb.append(entry.getValue());
            }
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ContentType)) {
            return false;
        }
        ContentType contentTypeObj = (ContentType)obj;
        if (this.contentType != null ? !this.contentType.equals(contentTypeObj.contentType) : contentTypeObj.contentType != null) {
            return false;
        }
        if (this.mediaType != null ? !this.mediaType.equals(contentTypeObj.mediaType) : contentTypeObj.mediaType != null) {
            return false;
        }
        if (this.parameters != null) {
            if (contentTypeObj.parameters == null) {
                return false;
            }
            if (this.parameters.size() != contentTypeObj.parameters.size()) {
                return false;
            }
            if (this.parameters.size() > 0) {
                for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                    if (!contentTypeObj.parameters.containsKey(entry.getKey())) {
                        return false;
                    }
                    String value = entry.getValue();
                    if (!(value != null ? !value.equals(contentTypeObj.parameters.get(entry.getKey())) : contentTypeObj.parameters.get(entry.getKey()) != null)) continue;
                    return false;
                }
            }
        } else if (contentTypeObj.parameters != null) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.contentType != null) {
            hashCode ^= this.contentType.hashCode();
        }
        if (this.mediaType != null) {
            hashCode ^= this.mediaType.hashCode();
        }
        if (this.parameters != null) {
            hashCode ^= 0x7A63;
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                hashCode ^= entry.getKey().hashCode();
                String value = entry.getValue();
                if (value == null) continue;
                hashCode ^= value.hashCode();
            }
        }
        return hashCode;
    }

    static {
        int i;
        charCharacteristicsTab = new byte[256];
        for (i = 0; i < separators.length(); ++i) {
            ContentType.charCharacteristicsTab[separators.charAt((int)i)] = 2;
        }
        for (i = 0; i < 32; ++i) {
            if (i == 9) continue;
            ContentType.charCharacteristicsTab[i] = 1;
        }
    }
}

