/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.optimizer;

import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractSimpleQueryModelVisitor;

public class UnionScopeChangeOptimizer
implements QueryOptimizer {
    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit((QueryModelVisitor)new UnionScopeChangeFixer());
    }

    private static class UnionArgChecker
    extends AbstractSimpleQueryModelVisitor<RuntimeException> {
        boolean containsBindOrValues = false;

        private UnionArgChecker() {
            super(false);
        }

        public void meet(Union union) {
            if (!union.isVariableScopeChange()) {
                super.meet(union);
            }
        }

        public void meet(Projection subselect) {
        }

        public void meet(Extension node) throws RuntimeException {
            this.containsBindOrValues = true;
        }

        public void meet(BindingSetAssignment bsa) {
            this.containsBindOrValues = true;
        }
    }

    private static class UnionScopeChangeFixer
    extends AbstractSimpleQueryModelVisitor<RuntimeException> {
        private UnionScopeChangeFixer() {
            super(true);
        }

        public void meet(Union union) {
            super.meet(union);
            if (union.isVariableScopeChange()) {
                UnionArgChecker checker = new UnionArgChecker();
                union.getLeftArg().visit((QueryModelVisitor)checker);
                if (checker.containsBindOrValues) {
                    return;
                }
                union.getRightArg().visit((QueryModelVisitor)checker);
                if (checker.containsBindOrValues) {
                    return;
                }
                union.setVariableScopeChange(false);
            }
        }
    }
}

