/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.base.security;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.dps.encrypt.AesEncryptor;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.naming.Context;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.DataSourceFactory;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.XADataSource;

public class EncryptedDataSourceFactory
extends DataSourceFactory {
    private static ExLogger log = ExLogger.getExLogger(EncryptedDataSourceFactory.class);

    public javax.sql.DataSource createDataSource(Properties properties, Context context, boolean XA) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, SQLException, NoSuchAlgorithmException, NoSuchPaddingException {
        PoolConfiguration poolProperties = EncryptedDataSourceFactory.parsePoolProperties((Properties)properties);
        String passwordToDecrypt = poolProperties.getPassword();
        String password = AesEncryptor.decrypt((byte[])passwordToDecrypt.getBytes());
        poolProperties.setPassword(password);
        if (poolProperties.getDataSourceJNDI() != null && poolProperties.getDataSource() == null) {
            this.performJNDILookup(context, poolProperties);
        }
        XADataSource dataSource = XA ? new XADataSource(poolProperties) : new DataSource(poolProperties);
        dataSource.createPool();
        return dataSource;
    }
}

