/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.fsutils;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import java.io.File;
import java.io.IOException;

public class InfraFSUtil {
    private static final ExLogger log = ExLogger.getExLogger(InfraFSUtil.class);
    public static final String SYSTEM = "system.dir";
    public static final String SEPARATOR = File.separator;
    protected static final String CONF = "conf/";
    public static final String DIGITOOL_HOME = "digitool.home";
    public static final String SOLR_HOME = "solr.solr.home";
    protected static String m_profileExtention = null;
    private static String m_systemConfDir = null;
    private static String m_systemHome = null;
    private static String m_solrHome = null;

    public static String getSystemConfDir() {
        if (m_systemConfDir != null) {
            return m_systemConfDir;
        }
        m_systemConfDir = InfraFSUtil.getCanonicalPath(InfraFSUtil.appendPath(InfraFSUtil.getHome(), CONF));
        return m_systemConfDir;
    }

    public static String getSolrHome() {
        if (m_solrHome == null && (m_solrHome = System.getProperty(SOLR_HOME)) == null) {
            m_solrHome = InfraFSUtil.getSystemConfDir() + File.separator + "solr";
            log.warn((Object)("solr.solr.home not found in System properties. setting solr home as subdir of conf dir: " + m_solrHome), new String[0]);
        }
        return m_solrHome;
    }

    public static String getSystemDir() {
        if (m_systemHome != null) {
            return m_systemHome;
        }
        m_systemHome = InfraFSUtil.getHome();
        return m_systemHome;
    }

    protected static synchronized String getHome() {
        if (m_systemHome != null) {
            return m_systemHome;
        }
        String m_systemHome = System.getProperty(DIGITOOL_HOME);
        if (!m_systemHome.endsWith(SEPARATOR)) {
            m_systemHome = m_systemHome + SEPARATOR;
        }
        if (m_systemHome == null) {
            return null;
        }
        String homeNoCase = m_systemHome.toLowerCase();
        int begin = homeNoCase.lastIndexOf(SYSTEM);
        if (begin != -1) {
            int end = m_systemHome.substring(begin += SYSTEM.length()).indexOf(SEPARATOR);
            m_profileExtention = m_systemHome.substring(begin, begin + end);
        }
        File f = new File(m_systemHome);
        try {
            m_systemHome = f.getCanonicalPath() + SEPARATOR;
            return m_systemHome;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String appendPath(String basePath, String appendPath) {
        if (basePath == null) {
            return basePath;
        }
        if (appendPath == null) {
            return basePath;
        }
        String localBasePath = basePath;
        if (!basePath.endsWith(File.separator)) {
            localBasePath = localBasePath + File.separator;
        }
        localBasePath = appendPath.startsWith(File.separator) ? localBasePath + appendPath.substring(1) : localBasePath + appendPath;
        return localBasePath;
    }

    public static String getCanonicalPath(String basePath) {
        if (basePath == null) {
            return basePath;
        }
        String localBasePath = basePath;
        File f = new File(basePath);
        try {
            localBasePath = f.getCanonicalPath();
            if (!localBasePath.endsWith(File.separator)) {
                localBasePath = localBasePath + File.separator;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return localBasePath;
    }
}

