/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model.resource;

import com.exlibris.core.infra.model.resource.EREConfiguration;
import com.exlibris.core.infra.model.resource.ParseEREConfig;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryBuilder {
    static Log log = LogFactory.getLog(QueryBuilder.class);

    public StringBuffer getExplainUrl(ParseEREConfig parser, String repo) {
        StringBuffer url = new StringBuffer();
        List<EREConfiguration> repoConfigValues = parser.getRepoValues(repo);
        if (repoConfigValues == null) {
            return null;
        }
        for (int c = 0; c < repoConfigValues.size(); ++c) {
            EREConfiguration repoConf = repoConfigValues.get(c);
            if (repo == null || !repoConf.getRepo().equals(repo)) continue;
            url = this.setBaseUrl(repoConf);
            break;
        }
        return url;
    }

    public StringBuffer getSingleRecordUrl(ParseEREConfig parser, String repo, String searchIndex, String CMSID) {
        StringBuffer url = new StringBuffer();
        List<EREConfiguration> repoConfigValues = parser.getRepoValues(repo);
        if (repoConfigValues == null) {
            return null;
        }
        for (int c = 0; c < repoConfigValues.size(); ++c) {
            EREConfiguration repoConf = repoConfigValues.get(c);
            if (repo == null || !repoConf.getRepo().equals(repo)) continue;
            url = this.setSearchUrl(repoConf, searchIndex, null, CMSID);
            break;
        }
        if (url != null) {
            return this.setMaxRecord(url, 1);
        }
        return url;
    }

    public StringBuffer getSearchUrl(ParseEREConfig parser, String repo, String searchIndex, String query, int start, int maxRecords) {
        StringBuffer url = new StringBuffer();
        List<EREConfiguration> repoConfigValues = parser.getRepoValues(repo);
        if (repoConfigValues == null) {
            return null;
        }
        for (int c = 0; c < repoConfigValues.size(); ++c) {
            EREConfiguration repoConf = repoConfigValues.get(c);
            if (repo == null || !repoConf.getRepo().equals(repo)) continue;
            url = this.setSearchUrl(repoConf, searchIndex, query, null);
            break;
        }
        StringBuffer startUrl = new StringBuffer();
        if (url != null) {
            startUrl = start == 0 || start == 1 ? this.setStartRecord(url, 1) : this.setStartRecord(url, start);
        }
        if (startUrl != null) {
            return this.setMaxRecord(startUrl, maxRecords);
        }
        return null;
    }

    private StringBuffer setBaseUrl(EREConfiguration repoConf) {
        StringBuffer baseUrl = new StringBuffer();
        baseUrl.append(repoConf.getParmValues().get("baseUrl")).append("?");
        if (repoConf.getParmValues().get("version") != null) {
            baseUrl.append("version").append("=").append(repoConf.getParmValues().get("version"));
        }
        return baseUrl;
    }

    private StringBuffer setSearchUrl(EREConfiguration repoConf, String searchIndex, String query, String CMSID) {
        StringBuffer baseUrl = new StringBuffer();
        baseUrl.append(repoConf.getParmValues().get("baseUrl")).append("?");
        Iterator<Map.Entry<String, String>> keyValuePairs1 = repoConf.getParmValues().entrySet().iterator();
        for (int i = 0; i < repoConf.getParmValues().size(); ++i) {
            Map.Entry<String, String> entry = keyValuePairs1.next();
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.equals("maximumRecords") || key.equals("updateURNUrl") || key.equals("indexName") || key.equals("indexName2") || key.equals("indexName3") || key.equals("baseUrl") || key.equals("synchUpdate")) continue;
            if (baseUrl.charAt(baseUrl.length() - 1) == '?') {
                baseUrl.append((Object)key).append("=").append((Object)value);
                continue;
            }
            baseUrl.append("&").append((Object)key).append("=").append((Object)value);
        }
        if (CMSID != null) {
            searchIndex = searchIndex.endsWith("=") ? searchIndex : searchIndex + "=";
            baseUrl.append("&query=").append(searchIndex).append(CMSID);
        } else if (query != null && searchIndex != null) {
            String nstr = this.normalizeQuery(query);
            baseUrl.append("&query=").append(searchIndex).append("=").append(nstr);
        } else if (query != null) {
            String nstr = this.normalizeQuery(query);
            baseUrl.append("&query=").append(nstr);
        }
        return baseUrl;
    }

    private String normalizeQuery(String query) {
        try {
            query = URLEncoder.encode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("failed to encode query: " + query));
        }
        return query;
    }

    private StringBuffer setStartRecord(StringBuffer baseUrl, int start) {
        if (baseUrl != null) {
            StringBuffer returnurl = baseUrl;
            returnurl.append("&").append("startRecord").append("=").append(start);
            return returnurl;
        }
        return null;
    }

    private StringBuffer setMaxRecord(StringBuffer baseUrl, int max) {
        if (baseUrl != null) {
            StringBuffer returnurl = baseUrl;
            returnurl.append("&").append("maximumRecords").append("=").append(max);
            return returnurl;
        }
        return null;
    }
}

