/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.common;

import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.infra.model.filetable.HFileTable;
import com.exlibris.core.infra.model.resource.EREConfiguration;
import com.exlibris.core.infra.model.resource.EREException;
import com.exlibris.core.infra.model.resource.ERESearchResultsSet;
import com.exlibris.core.infra.model.resource.ParseEREConfig;
import com.exlibris.core.infra.model.resource.ParseSRWExplainResponse;
import com.exlibris.core.infra.model.resource.QueryBuilder;
import com.exlibris.core.infra.svc.api.FileTableManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExternalResourceExplorer {
    static Log log = LogFactory.getLog(ExternalResourceExplorer.class);
    private static ExternalResourceExplorer instance = new ExternalResourceExplorer();
    static ParseEREConfig configParser = null;
    static Map<String, List<String>> allReposIndexes = new HashMap<String, List<String>>();
    static QueryBuilder queryBuilder = new QueryBuilder();

    public static void reset() {
        String configFile = ExternalResourceExplorer.loadFileFromDb();
        ExternalResourceExplorer.init(configFile);
    }

    public static ExternalResourceExplorer getInstance() {
        return instance;
    }

    private static String loadFileFromDb() {
        String file = null;
        try {
            FileTableManager manager = (FileTableManager)ServiceLocator.getInstance().lookUp(FileTableManager.class);
            HFileTable confFile = manager.getFileByKey("com.exlibris.dps.infra.externalresourceexplorer");
            file = confFile.getFile();
        }
        catch (Throwable e) {
            log.error((Object)("Failed to load external resource explorer configuration from com.exlibris.dps.infra.externalresourceexplorer: " + e.getMessage() + e.getMessage() + e.getCause()));
        }
        return file;
    }

    public static void init(String ConfigXML) {
        int i;
        allReposIndexes = new HashMap<String, List<String>>();
        configParser = new ParseEREConfig(ConfigXML);
        List<String> repos = ExternalResourceExplorer.getRepositoryList();
        for (i = 0; i < repos.size(); ++i) {
            ExternalResourceExplorer.setRepoIndexes(repos.get(i));
        }
        while (repos.size() != allReposIndexes.size()) {
            for (i = 0; i < repos.size(); ++i) {
                String repo = repos.get(i);
                if (allReposIndexes.get(repo) != null) continue;
                repos.remove(repo);
            }
        }
    }

    public static List<String> getRepositoryList() {
        return configParser.getRepos();
    }

    public static boolean synchUpdate(String repo) {
        EREConfiguration conf = configParser.getConfigData().get(repo).get(0);
        String synchUpdate = conf.getParmValues().get("synchUpdate");
        return synchUpdate != null ? Boolean.valueOf(synchUpdate) : true;
    }

    public static boolean updateUrlExists(String repo) {
        String updateUrl = configParser.getVoyagerUpdateUrlMap().get(repo);
        return updateUrl != null;
    }

    public static List<String> getAllRepoIndexes(String repositoryCode) {
        ArrayList<String> indexes = new ArrayList<String>();
        indexes.addAll((Collection)allReposIndexes.get(repositoryCode));
        return indexes;
    }

    public static ERESearchResultsSet fetchSingleRecord(String repo, String repositoryId, String searchIndex) throws EREException {
        StringBuffer urlstr = queryBuilder.getSingleRecordUrl(configParser, repo, searchIndex, repositoryId);
        log.info((Object)("Url - " + urlstr));
        return ExternalResourceExplorer.getContent(urlstr);
    }

    public static ERESearchResultsSet getSearchResultSet(String repo, String searchIndex, String query, int start, int maxRecords) throws EREException {
        StringBuffer urlstr = queryBuilder.getSearchUrl(configParser, repo, searchIndex, query, start, maxRecords);
        log.info((Object)("Url - " + urlstr));
        return ExternalResourceExplorer.getContent(urlstr);
    }

    public static String getUpdateFlagUrl(String repo) {
        Map<String, String> UpdateUrlValues = configParser.getVoyagerUpdateUrlMap();
        if (UpdateUrlValues == null) {
            return null;
        }
        String updateUrl = UpdateUrlValues.get(repo);
        return updateUrl;
    }

    public static String getDetachFlagUrl(String repo) {
        Map<String, String> detachUrlValues = configParser.getAlephDetachUrlMap();
        if (detachUrlValues == null) {
            return null;
        }
        String detachUrl = detachUrlValues.get(repo);
        return detachUrl;
    }

    public static String getRepositoryType(String repo) {
        return configParser.getRepoType(repo);
    }

    public static ParseEREConfig getConfigParser() {
        return configParser;
    }

    private static void setRepoIndexes(String repo) {
        List<String> indx = null;
        try {
            indx = ExternalResourceExplorer.getExplainResultSet(repo);
        }
        catch (EREException e) {
            log.error((Object)("This repo will be taken out" + repo));
        }
        if (indx != null && indx.size() > 1) {
            allReposIndexes.put(repo, indx);
        }
    }

    private static List<String> getExplainResultSet(String repo) throws EREException {
        StringBuffer urlstr = queryBuilder.getExplainUrl(configParser, repo);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Url - " + urlstr));
        }
        if (urlstr != null) {
            String content = null;
            try {
                URL url = new URL(urlstr.toString());
                content = ExternalResourceExplorer.getUrlContent(url);
            }
            catch (Exception e) {
                log.error((Object)("Get Search Results Set exception " + e.getMessage()));
                throw new EREException(e.getMessage());
            }
            if (content != null) {
                ParseSRWExplainResponse explainParser = new ParseSRWExplainResponse(content);
                return explainParser.getRepoIndexes();
            }
        }
        log.error((Object)"Url for those search parms is null.");
        throw new EREException("No indexes for this repository.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUrlContent(URL url) throws EREException {
        URLConnection conn = null;
        try {
            conn = url.openConnection();
        }
        catch (IOException ex) {
            throw new EREException("There is no connection to server.");
        }
        if (conn == null) {
            log.error((Object)"External Search Engine - No connection to server");
            return null;
        }
        String content = new String();
        InputStream stream = null;
        ByteArrayOutputStream baos = null;
        try {
            conn.setReadTimeout(30000);
            stream = conn.getInputStream();
            baos = new ByteArrayOutputStream();
            int fileSize = stream.available();
            byte[] buffer = new byte[fileSize];
            int bytesRead = 0;
            while ((bytesRead = stream.read(buffer, 0, fileSize)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            content = new String(baos.toByteArray(), "UTF-8");
        }
        catch (Exception e) {
            String string;
            try {
                log.error((Object)("Exception in External Search Engine Impl " + e.getMessage()), (Throwable)e);
                string = null;
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(stream);
                IOUtil.closeQuietly(baos);
                throw throwable;
            }
            IOUtil.closeQuietly(stream);
            IOUtil.closeQuietly(baos);
            return string;
        }
        IOUtil.closeQuietly(stream);
        IOUtil.closeQuietly(baos);
        return content;
    }

    private static ERESearchResultsSet getContent(StringBuffer urlstr) throws EREException {
        if (urlstr != null) {
            String content = null;
            try {
                URL url = new URL(urlstr.toString());
                content = ExternalResourceExplorer.getUrlContent(url);
            }
            catch (Exception e) {
                log.error((Object)("Get Search Results Set exception " + e.getMessage()));
                throw new EREException(e.getMessage());
            }
            if (content != null) {
                return new ERESearchResultsSet(content);
            }
        }
        log.error((Object)"Url for those search parms is null.");
        throw new EREException("No response available for this repository.");
    }

    public static String getParameterValue(String repositoryName, String parameter) {
        String value = null;
        Map<String, List<EREConfiguration>> configData = null;
        if (configParser != null && (configData = configParser.getConfigData()) != null && configData.keySet() != null) {
            for (String repository : configData.keySet()) {
                if (!repository.equals(repositoryName)) continue;
                List<EREConfiguration> configuration = configData.get(repository);
                Map<String, String> parmValues = configuration.get(0).getParmValues();
                value = parmValues.get(parameter);
                break;
            }
        } else {
            log.warn((Object)("No configuration was found for repository: " + repositoryName));
        }
        return value;
    }

    static {
        String configFile = ExternalResourceExplorer.loadFileFromDb();
        ExternalResourceExplorer.init(configFile);
    }
}

